/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.StartActivityManager;
import java.util.ArrayList;
import java.util.List;

public final class PermissionPageFragment
extends Fragment
implements Runnable {
    private static final String REQUEST_PERMISSIONS = "request_permissions";
    @Nullable
    private OnPermissionPageCallback mCallBack;
    private boolean mRequestFlag;
    private boolean mStartActivityFlag;

    public static void launch(@NonNull Activity activity, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        PermissionPageFragment fragment = new PermissionPageFragment();
        Bundle bundle = new Bundle();
        if (permissions instanceof ArrayList) {
            bundle.putStringArrayList(REQUEST_PERMISSIONS, (ArrayList)permissions);
        } else {
            bundle.putStringArrayList(REQUEST_PERMISSIONS, new ArrayList<String>(permissions));
        }
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setOnPermissionPageCallback(callback);
        fragment.attachByActivity(activity);
    }

    public void attachByActivity(@NonNull Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        if (fragmentManager == null) {
            return;
        }
        fragmentManager.beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachByActivity(@NonNull Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        if (fragmentManager == null) {
            return;
        }
        fragmentManager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void setOnPermissionPageCallback(@Nullable OnPermissionPageCallback callback) {
        this.mCallBack = callback;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequestFlag) {
            this.detachByActivity(this.getActivity());
            return;
        }
        if (this.mStartActivityFlag) {
            return;
        }
        this.mStartActivityFlag = true;
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList permissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        StartActivityManager.startActivityForResult(this, PermissionUtils.getSmartPermissionIntent((Context)this.getActivity(), permissions), 1025);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != 1025) {
            return;
        }
        Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null) {
            return;
        }
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        PermissionUtils.postActivityResult(allPermissions, this);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        OnPermissionPageCallback callback = this.mCallBack;
        this.mCallBack = null;
        if (callback == null) {
            this.detachByActivity(activity);
            return;
        }
        Bundle arguments = this.getArguments();
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        List<String> grantedPermissions = PermissionApi.getGrantedPermissions((Context)activity, allPermissions);
        if (grantedPermissions.size() == allPermissions.size()) {
            callback.onGranted();
        } else {
            callback.onDenied();
        }
        this.detachByActivity(activity);
    }
}

