/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;
import com.hjq.permissions.StartActivityManager;

final class WindowPermissionCompat {
    private static final String OP_SYSTEM_ALERT_WINDOW_FIELD_NAME = "OP_SYSTEM_ALERT_WINDOW";
    private static final int OP_SYSTEM_ALERT_WINDOW_DEFAULT_VALUE = 24;

    WindowPermissionCompat() {
    }

    static boolean isGrantedPermission(@NonNull Context context) {
        if (AndroidVersion.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        if (AndroidVersion.isAndroid4_4()) {
            return PermissionUtils.checkOpNoThrow(context, OP_SYSTEM_ALERT_WINDOW_FIELD_NAME, 24);
        }
        return true;
    }

    static Intent getPermissionIntent(@NonNull Context context) {
        if (AndroidVersion.isAndroid6()) {
            if (AndroidVersion.isAndroid11() && PhoneRomUtils.isMiui() && PhoneRomUtils.isMiuiOptimization()) {
                Intent intent = PermissionIntentManager.getMiuiPermissionPageIntent(context);
                intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
                return intent;
            }
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            intent.setData(PermissionUtils.getPackageNameUri(context));
            if (PermissionUtils.areActivityIntent(context, intent)) {
                return intent;
            }
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
            return intent;
        }
        if (PhoneRomUtils.isEmui()) {
            Intent intent = PermissionIntentManager.getEmuiWindowPermissionPageIntent(context);
            intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isMiui()) {
            Intent intent = null;
            if (PhoneRomUtils.isMiuiOptimization()) {
                intent = PermissionIntentManager.getMiuiWindowPermissionPageIntent(context);
            }
            intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isColorOs()) {
            Intent intent = PermissionIntentManager.getColorOsWindowPermissionPageIntent(context);
            intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isOriginOs()) {
            Intent intent = PermissionIntentManager.getOriginOsWindowPermissionPageIntent(context);
            intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        if (PhoneRomUtils.isOneUi()) {
            Intent intent = PermissionIntentManager.getOneUiWindowPermissionPageIntent(context);
            intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }
}

