/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidManifestParser;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PhoneRomUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    PermissionUtils() {
    }

    @RequiresApi(api=23)
    static boolean checkSelfPermission(@NonNull Context context, @NonNull String permission2) {
        return context.checkSelfPermission(permission2) == 0;
    }

    @RequiresApi(value=19)
    static boolean checkOpNoThrow(Context context, String opFieldName, int opDefaultValue) {
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        ApplicationInfo appInfo = context.getApplicationInfo();
        String pkg = context.getApplicationContext().getPackageName();
        int uid = appInfo.uid;
        try {
            int opValue;
            Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
            try {
                Field opValueField = appOpsClass.getDeclaredField(opFieldName);
                opValue = (Integer)opValueField.get(Integer.class);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                opValue = opDefaultValue;
            }
            Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
            return (Integer)checkOpNoThrowMethod.invoke((Object)appOps, opValue, uid, pkg) == 0;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            return true;
        }
    }

    @RequiresApi(value=19)
    static boolean checkOpNoThrow(Context context, String opName) {
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        int mode = AndroidVersion.isAndroid10() ? appOps.unsafeCheckOpNoThrow(opName, context.getApplicationInfo().uid, context.getPackageName()) : appOps.checkOpNoThrow(opName, context.getApplicationInfo().uid, context.getPackageName());
        return mode == 0;
    }

    @RequiresApi(api=23)
    static boolean shouldShowRequestPermissionRationale(@NonNull Activity activity, @NonNull String permission2) {
        if (AndroidVersion.getAndroidVersionCode() == 31) {
            try {
                PackageManager packageManager = activity.getApplication().getPackageManager();
                Method method = PackageManager.class.getMethod("shouldShowRequestPermissionRationale", String.class);
                return (Boolean)method.invoke((Object)packageManager, permission2);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return activity.shouldShowRequestPermissionRationale(permission2);
    }

    static void postActivityResult(@NonNull List<String> permissions, @NonNull Runnable runnable) {
        long delayMillis = AndroidVersion.isAndroid11() ? 200L : 300L;
        if (PhoneRomUtils.isEmui() || PhoneRomUtils.isHarmonyOs()) {
            delayMillis = AndroidVersion.isAndroid8() ? 300L : 500L;
        } else if (PhoneRomUtils.isMiui() && AndroidVersion.isAndroid11() && PermissionUtils.containsPermission(permissions, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            delayMillis = 1000L;
        }
        PermissionUtils.postDelayed(runnable, delayMillis);
    }

    static void postDelayed(@NonNull Runnable runnable, long delayMillis) {
        HANDLER.postDelayed(runnable, delayMillis);
    }

    static boolean isDebugMode(@NonNull Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    @Nullable
    static AndroidManifestInfo getAndroidManifestInfo(Context context) {
        int apkPathCookie = PermissionUtils.findApkPathCookie(context, context.getApplicationInfo().sourceDir);
        if (apkPathCookie == 0) {
            return null;
        }
        AndroidManifestInfo androidManifestInfo = null;
        try {
            androidManifestInfo = AndroidManifestParser.parseAndroidManifest(context, apkPathCookie);
            if (!TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)androidManifestInfo.packageName)) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return androidManifestInfo;
    }

    static void optimizePermissionResults(Activity activity, @NonNull String[] permissions, @NonNull int[] grantResults) {
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (PermissionApi.isSpecialPermission(permission2)) {
                grantResults[i] = PermissionApi.getPermissionResult((Context)activity, permission2);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
                grantResults[i] = PermissionApi.getPermissionResult((Context)activity, permission2);
                continue;
            }
            if (AndroidVersion.isAndroid14() && (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VIDEO"))) {
                grantResults[i] = PermissionApi.getPermissionResult((Context)activity, permission2);
                continue;
            }
            if (AndroidVersion.isAndroid13() && AndroidVersion.getTargetSdkVersionCode((Context)activity) >= 33 && PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                grantResults[i] = PermissionApi.getPermissionResult((Context)activity, permission2);
                continue;
            }
            if (Permission.getDangerPermissionFromAndroidVersion(permission2) <= AndroidVersion.getAndroidVersionCode()) continue;
            grantResults[i] = PermissionApi.getPermissionResult((Context)activity, permission2);
        }
    }

    @NonNull
    static <T> ArrayList<T> asArrayList(T ... array) {
        int initialCapacity = 0;
        if (array != null) {
            initialCapacity = array.length;
        }
        ArrayList<T> list = new ArrayList<T>(initialCapacity);
        if (array == null || array.length == 0) {
            return list;
        }
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    @NonNull
    static <T> ArrayList<T> asArrayLists(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (arrays == null || arrays.length == 0) {
            return list;
        }
        for (T[] ts : arrays) {
            list.addAll(PermissionUtils.asArrayList(ts));
        }
        return list;
    }

    @Nullable
    static Activity findActivity(@NonNull Context context) {
        do {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }

    @SuppressLint(value={"PrivateApi"})
    static int findApkPathCookie(@NonNull Context context, @NonNull String apkPath) {
        AssetManager assets = context.getAssets();
        try {
            Method addAssetPathMethod;
            Integer cookie;
            if (AndroidVersion.getTargetSdkVersionCode(context) >= 28 && AndroidVersion.getAndroidVersionCode() >= 28 && AndroidVersion.getAndroidVersionCode() < 30) {
                Method metaGetDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, Class[].class);
                metaGetDeclaredMethod.setAccessible(true);
                Method findCookieForPathMethod = (Method)metaGetDeclaredMethod.invoke(AssetManager.class, "findCookieForPath", new Class[]{String.class});
                if (findCookieForPathMethod != null) {
                    findCookieForPathMethod.setAccessible(true);
                    cookie = (Integer)findCookieForPathMethod.invoke((Object)context.getAssets(), apkPath);
                    if (cookie != null) {
                        return cookie;
                    }
                }
            }
            if ((cookie = (Integer)(addAssetPathMethod = assets.getClass().getDeclaredMethod("addAssetPath", String.class)).invoke((Object)assets, apkPath)) != null) {
                return cookie;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static boolean isScopedStorage(@NonNull Context context) {
        try {
            String metaKey = "ScopedStorage";
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return Boolean.parseBoolean(String.valueOf(metaData.get(metaKey)));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    @SuppressLint(value={"SwitchIntDef"})
    static void lockActivityOrientation(@NonNull Activity activity) {
        try {
            switch (activity.getResources().getConfiguration().orientation) {
                case 2: {
                    activity.setRequestedOrientation(PermissionUtils.isActivityReverse(activity) ? 8 : 0);
                    break;
                }
                case 1: {
                    activity.setRequestedOrientation(PermissionUtils.isActivityReverse(activity) ? 9 : 1);
                    break;
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    static boolean isActivityReverse(@NonNull Activity activity) {
        int activityRotation = AndroidVersion.isAndroid11() ? activity.getDisplay().getRotation() : activity.getWindowManager().getDefaultDisplay().getRotation();
        switch (activityRotation) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static boolean areActivityIntent(@NonNull Context context, @Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (AndroidVersion.isAndroid13()) {
            return !packageManager.queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of((long)65536L)).isEmpty();
        }
        return !packageManager.queryIntentActivities(intent, 65536).isEmpty();
    }

    static Intent getSmartPermissionIntent(@NonNull Context context, @Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        if (!PermissionApi.containsSpecialPermission(permissions)) {
            if (permissions.size() == 1) {
                return PermissionApi.getPermissionIntent(context, permissions.get(0));
            }
            return PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        switch (permissions.size()) {
            case 1: {
                return PermissionApi.getPermissionIntent(context, permissions.get(0));
            }
            case 2: {
                if (AndroidVersion.isAndroid13() || !PermissionUtils.containsPermission(permissions, "android.permission.NOTIFICATION_SERVICE") || !PermissionUtils.containsPermission(permissions, "android.permission.POST_NOTIFICATIONS")) break;
                return PermissionApi.getPermissionIntent(context, "android.permission.NOTIFICATION_SERVICE");
            }
            case 3: {
                if (!AndroidVersion.isAndroid11() || !PermissionUtils.containsPermission(permissions, "android.permission.MANAGE_EXTERNAL_STORAGE") || !PermissionUtils.containsPermission(permissions, "android.permission.READ_EXTERNAL_STORAGE") || !PermissionUtils.containsPermission(permissions, "android.permission.WRITE_EXTERNAL_STORAGE")) break;
                return PermissionApi.getPermissionIntent(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
            }
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }

    static boolean equalsPermission(@NonNull String permission1, @NonNull String permission2) {
        int length = permission1.length();
        if (length != permission2.length()) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (permission1.charAt(i) == permission2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean containsPermission(@NonNull Collection<String> permissions, @NonNull String permission2) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (String s : permissions) {
            if (!PermissionUtils.equalsPermission(s, permission2)) continue;
            return true;
        }
        return false;
    }

    static Uri getPackageNameUri(@NonNull Context context) {
        return Uri.parse((String)("package:" + context.getPackageName()));
    }
}

