/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV19;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=21)
class PermissionDelegateImplV21
extends PermissionDelegateImplV19 {
    PermissionDelegateImplV21() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            return PermissionDelegateImplV21.isGrantedPackagePermission(context);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            return false;
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            return PermissionDelegateImplV21.getPackagePermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    private static boolean isGrantedPackagePermission(@NonNull Context context) {
        return PermissionUtils.checkOpNoThrow(context, "android:get_usage_stats");
    }

    private static Intent getPackagePermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
        if (AndroidVersion.isAndroid10()) {
            intent.setData(PermissionUtils.getPackageNameUri(context));
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

