/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.AndroidVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

final class PhoneRomUtils {
    private static final String[] ROM_HUAWEI = new String[]{"huawei"};
    private static final String[] ROM_VIVO = new String[]{"vivo"};
    private static final String[] ROM_XIAOMI = new String[]{"xiaomi"};
    private static final String[] ROM_OPPO = new String[]{"oppo"};
    private static final String[] ROM_LEECO = new String[]{"leeco", "letv"};
    private static final String[] ROM_360 = new String[]{"360", "qiku"};
    private static final String[] ROM_ZTE = new String[]{"zte"};
    private static final String[] ROM_ONEPLUS = new String[]{"oneplus"};
    private static final String[] ROM_NUBIA = new String[]{"nubia"};
    private static final String[] ROM_SAMSUNG = new String[]{"samsung"};
    private static final String[] ROM_HONOR = new String[]{"honor"};
    private static final String ROM_NAME_MIUI = "ro.miui.ui.version.name";
    private static final String VERSION_PROPERTY_HUAWEI = "ro.build.version.emui";
    private static final String VERSION_PROPERTY_VIVO = "ro.vivo.os.build.display.id";
    private static final String VERSION_PROPERTY_XIAOMI = "ro.build.version.incremental";
    private static final String[] VERSION_PROPERTY_OPPO = new String[]{"ro.build.version.opporom", "ro.build.version.oplusrom.display"};
    private static final String VERSION_PROPERTY_LEECO = "ro.letv.release.version";
    private static final String VERSION_PROPERTY_360 = "ro.build.uiversion";
    private static final String VERSION_PROPERTY_ZTE = "ro.build.MiFavor_version";
    private static final String VERSION_PROPERTY_ONEPLUS = "ro.rom.version";
    private static final String VERSION_PROPERTY_NUBIA = "ro.build.rom.id";
    private static final String[] VERSION_PROPERTY_MAGIC = new String[]{"msc.config.magic.version", "ro.build.version.magic"};

    private PhoneRomUtils() {
    }

    static boolean isEmui() {
        return !TextUtils.isEmpty((CharSequence)PhoneRomUtils.getPropertyName(VERSION_PROPERTY_HUAWEI));
    }

    static boolean isMiui() {
        return !TextUtils.isEmpty((CharSequence)PhoneRomUtils.getPropertyName(ROM_NAME_MIUI));
    }

    static boolean isColorOs() {
        for (String property : VERSION_PROPERTY_OPPO) {
            String versionName = PhoneRomUtils.getPropertyName(property);
            if (TextUtils.isEmpty((CharSequence)versionName)) continue;
            return true;
        }
        return false;
    }

    static boolean isOriginOs() {
        return !TextUtils.isEmpty((CharSequence)PhoneRomUtils.getPropertyName(VERSION_PROPERTY_VIVO));
    }

    @SuppressLint(value={"PrivateApi"})
    static boolean isOneUi() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_SAMSUNG);
    }

    static boolean isHarmonyOs() {
        if (!AndroidVersion.isAndroid10()) {
            return false;
        }
        try {
            Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
            Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
            return "Harmony".equalsIgnoreCase(String.valueOf(osBrand));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    static boolean isMagicOs() {
        return PhoneRomUtils.isRightRom(PhoneRomUtils.getBrand(), PhoneRomUtils.getManufacturer(), ROM_HONOR);
    }

    @SuppressLint(value={"PrivateApi"})
    static boolean isMiuiOptimization() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getMethod = clazz.getMethod("get", String.class, String.class);
            String ctsValue = String.valueOf(getMethod.invoke(clazz, "ro.miui.cts", ""));
            Method getBooleanMethod = clazz.getMethod("getBoolean", String.class, Boolean.TYPE);
            return Boolean.parseBoolean(String.valueOf(getBooleanMethod.invoke(clazz, "persist.sys.miui_optimization", !"1".equals(ctsValue))));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Nullable
    static String getRomVersionName() {
        String manufacturer;
        String brand = PhoneRomUtils.getBrand();
        if (PhoneRomUtils.isRightRom(brand, manufacturer = PhoneRomUtils.getManufacturer(), ROM_HUAWEI)) {
            String version = PhoneRomUtils.getPropertyName(VERSION_PROPERTY_HUAWEI);
            String[] temp = version.split("_");
            if (temp.length > 1) {
                return temp[1];
            }
            if (version.contains("EmotionUI")) {
                return version.replaceFirst("EmotionUI\\s*", "");
            }
            return version;
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_VIVO)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_VIVO);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_XIAOMI)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_XIAOMI);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_OPPO)) {
            for (String property : VERSION_PROPERTY_OPPO) {
                String versionName = PhoneRomUtils.getPropertyName(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_LEECO)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_LEECO);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_360)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_360);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_ZTE)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_ZTE);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_ONEPLUS)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_ONEPLUS);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_NUBIA)) {
            return PhoneRomUtils.getPropertyName(VERSION_PROPERTY_NUBIA);
        }
        if (PhoneRomUtils.isRightRom(brand, manufacturer, ROM_HONOR)) {
            for (String property : VERSION_PROPERTY_MAGIC) {
                String versionName = PhoneRomUtils.getPropertyName(property);
                if (TextUtils.isEmpty((CharSequence)property)) continue;
                return versionName;
            }
            return "";
        }
        return PhoneRomUtils.getPropertyName("");
    }

    private static boolean isRightRom(String brand, String manufacturer, String ... names) {
        for (String name : names) {
            if (!brand.contains(name) && !manufacturer.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static String getBrand() {
        return Build.BRAND.toLowerCase();
    }

    private static String getManufacturer() {
        return Build.MANUFACTURER.toLowerCase();
    }

    private static String getPropertyName(String propertyName) {
        String result = "";
        if (!TextUtils.isEmpty((CharSequence)propertyName)) {
            result = PhoneRomUtils.getSystemProperty(propertyName);
        }
        return result;
    }

    private static String getSystemProperty(String name) {
        String prop = PhoneRomUtils.getSystemPropertyByShell(name);
        if (!TextUtils.isEmpty((CharSequence)prop)) {
            return prop;
        }
        prop = PhoneRomUtils.getSystemPropertyByStream(name);
        if (!TextUtils.isEmpty((CharSequence)prop)) {
            return prop;
        }
        if (Build.VERSION.SDK_INT < 28) {
            return PhoneRomUtils.getSystemPropertyByReflect(name);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByShell(String propName) {
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            String ret = input.readLine();
            if (ret != null) {
                String string = ret;
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private static String getSystemPropertyByStream(String key) {
        try {
            Properties prop = new Properties();
            FileInputStream is = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            prop.load(is);
            return prop.getProperty(key, "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getSystemPropertyByReflect(String key) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method getMethod = clz.getMethod("get", String.class, String.class);
            return (String)getMethod.invoke(clz, key, "");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return "";
    }
}

