/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;
import com.hjq.permissions.StartActivityManager;

final class GetInstalledAppsPermissionCompat {
    private static final String MIUI_OP_GET_INSTALLED_APPS_FIELD_NAME = "OP_GET_INSTALLED_APPS";
    private static final int MIUI_OP_GET_INSTALLED_APPS_DEFAULT_VALUE = 10022;

    GetInstalledAppsPermissionCompat() {
    }

    static boolean isGrantedPermission(@NonNull Context context) {
        if (!AndroidVersion.isAndroid4_4()) {
            return true;
        }
        if (AndroidVersion.isAndroid6() && GetInstalledAppsPermissionCompat.isSupportGetInstalledAppsPermission(context)) {
            return PermissionUtils.checkSelfPermission(context, "com.android.permission.GET_INSTALLED_APPS");
        }
        if (PhoneRomUtils.isMiui() && GetInstalledAppsPermissionCompat.isMiuiSupportGetInstalledAppsPermission()) {
            if (!PhoneRomUtils.isMiuiOptimization()) {
                return true;
            }
            return PermissionUtils.checkOpNoThrow(context, MIUI_OP_GET_INSTALLED_APPS_FIELD_NAME, 10022);
        }
        return true;
    }

    static boolean isPermissionPermanentDenied(@NonNull Activity activity) {
        if (!AndroidVersion.isAndroid4_4()) {
            return false;
        }
        if (AndroidVersion.isAndroid6() && GetInstalledAppsPermissionCompat.isSupportGetInstalledAppsPermission((Context)activity)) {
            return !PermissionUtils.checkSelfPermission((Context)activity, "com.android.permission.GET_INSTALLED_APPS") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "com.android.permission.GET_INSTALLED_APPS");
        }
        if (PhoneRomUtils.isMiui() && GetInstalledAppsPermissionCompat.isMiuiSupportGetInstalledAppsPermission()) {
            if (!PhoneRomUtils.isMiuiOptimization()) {
                return false;
            }
            return !GetInstalledAppsPermissionCompat.isGrantedPermission((Context)activity);
        }
        return false;
    }

    static Intent getPermissionIntent(@NonNull Context context) {
        if (PhoneRomUtils.isMiui()) {
            Intent intent = null;
            if (PhoneRomUtils.isMiuiOptimization()) {
                intent = PermissionIntentManager.getMiuiPermissionPageIntent(context);
            }
            intent = StartActivityManager.addSubIntentToMainIntent(intent, PermissionIntentManager.getApplicationDetailsIntent(context));
            return intent;
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context);
    }

    @RequiresApi(api=23)
    private static boolean isSupportGetInstalledAppsPermission(Context context) {
        try {
            PermissionInfo permissionInfo = context.getPackageManager().getPermissionInfo("com.android.permission.GET_INSTALLED_APPS", 0);
            if (permissionInfo != null) {
                if (AndroidVersion.isAndroid9()) {
                    return permissionInfo.getProtection() == 1;
                }
                return (permissionInfo.protectionLevel & 0xF) == 1;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        try {
            return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"oem_installed_apps_runtime_permission_enable") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isMiuiSupportGetInstalledAppsPermission() {
        if (!AndroidVersion.isAndroid4_4()) {
            return true;
        }
        try {
            Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
            appOpsClass.getDeclaredField(MIUI_OP_GET_INSTALLED_APPS_FIELD_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return true;
    }
}

