/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.PhoneRomUtils;
import com.hjq.permissions.StartActivityManager;

final class PermissionIntentManager {
    private static final String EMUI_MOBILE_MANAGER_APP_PACKAGE_NAME = "com.huawei.systemmanager";
    private static final String MIUI_MOBILE_MANAGER_APP_PACKAGE_NAME = "com.miui.securitycenter";
    private static final String COLOR_OS_SAFE_CENTER_APP_PACKAGE_NAME_1 = "com.oppo.safe";
    private static final String COLOR_OS_SAFE_CENTER_APP_PACKAGE_NAME_2 = "com.color.safecenter";
    private static final String COLOR_OS_SAFE_CENTER_APP_PACKAGE_NAME_3 = "com.oplus.safecenter";
    private static final String ORIGIN_OS_MOBILE_MANAGER_APP_PACKAGE_NAME = "com.iqoo.secure";

    PermissionIntentManager() {
    }

    @Nullable
    static Intent getEmuiWindowPermissionPageIntent(Context context) {
        Intent addViewMonitorActivityIntent = new Intent();
        addViewMonitorActivityIntent.setClassName(EMUI_MOBILE_MANAGER_APP_PACKAGE_NAME, "com.huawei.systemmanager.addviewmonitor.AddViewMonitorActivity");
        Intent notificationManagementActivityIntent = new Intent();
        notificationManagementActivityIntent.setClassName(EMUI_MOBILE_MANAGER_APP_PACKAGE_NAME, "com.huawei.notificationmanager.ui.NotificationManagmentActivity");
        Intent huaWeiMobileManagerAppIntent = PermissionIntentManager.getHuaWeiMobileManagerAppIntent(context);
        String romVersionName = PhoneRomUtils.getRomVersionName();
        if (romVersionName == null) {
            romVersionName = "";
        }
        Intent intent = null;
        if (romVersionName.startsWith("3.0")) {
            if (PermissionUtils.areActivityIntent(context, notificationManagementActivityIntent)) {
                intent = notificationManagementActivityIntent;
            }
            if (PermissionUtils.areActivityIntent(context, addViewMonitorActivityIntent)) {
                intent = StartActivityManager.addSubIntentToMainIntent(intent, addViewMonitorActivityIntent);
            }
        } else {
            if (PermissionUtils.areActivityIntent(context, addViewMonitorActivityIntent)) {
                intent = addViewMonitorActivityIntent;
            }
            if (PermissionUtils.areActivityIntent(context, notificationManagementActivityIntent)) {
                intent = StartActivityManager.addSubIntentToMainIntent(intent, notificationManagementActivityIntent);
            }
        }
        if (PermissionUtils.areActivityIntent(context, huaWeiMobileManagerAppIntent)) {
            intent = StartActivityManager.addSubIntentToMainIntent(intent, huaWeiMobileManagerAppIntent);
        }
        return intent;
    }

    @Nullable
    static Intent getMiuiWindowPermissionPageIntent(Context context) {
        return PermissionIntentManager.getMiuiPermissionPageIntent(context);
    }

    @Nullable
    static Intent getColorOsWindowPermissionPageIntent(Context context) {
        Intent permissionTopActivityActionIntent = new Intent("com.oppo.safe.permission.PermissionTopActivity");
        Intent oppoSafeCenterAppIntent = PermissionIntentManager.getOppoSafeCenterAppIntent(context);
        Intent intent = null;
        if (PermissionUtils.areActivityIntent(context, permissionTopActivityActionIntent)) {
            intent = permissionTopActivityActionIntent;
        }
        if (PermissionUtils.areActivityIntent(context, oppoSafeCenterAppIntent)) {
            intent = StartActivityManager.addSubIntentToMainIntent(intent, oppoSafeCenterAppIntent);
        }
        return intent;
    }

    @Nullable
    static Intent getOriginOsWindowPermissionPageIntent(Context context) {
        Intent intent = PermissionIntentManager.getVivoMobileManagerAppIntent(context);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    @Nullable
    static Intent getOneUiWindowPermissionPageIntent(Context context) {
        return PermissionIntentManager.getOneUiPermissionPageIntent(context);
    }

    @Nullable
    static Intent getMiuiPermissionPageIntent(Context context) {
        Intent appPermEditorActionIntent = new Intent().setAction("miui.intent.action.APP_PERM_EDITOR").putExtra("extra_pkgname", context.getPackageName());
        Intent xiaoMiMobileManagerAppIntent = PermissionIntentManager.getXiaoMiMobileManagerAppIntent(context);
        Intent intent = null;
        if (PermissionUtils.areActivityIntent(context, appPermEditorActionIntent)) {
            intent = appPermEditorActionIntent;
        }
        if (PermissionUtils.areActivityIntent(context, xiaoMiMobileManagerAppIntent)) {
            intent = StartActivityManager.addSubIntentToMainIntent(intent, xiaoMiMobileManagerAppIntent);
        }
        return intent;
    }

    @Nullable
    static Intent getOriginOsPermissionPageIntent(Context context) {
        Intent intent = new Intent("permission.intent.action.softPermissionDetail");
        intent.putExtra("packagename", context.getPackageName());
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    @Nullable
    static Intent getOneUiPermissionPageIntent(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.Settings$AppOpsDetailsActivity");
        Bundle extraShowFragmentArguments = new Bundle();
        extraShowFragmentArguments.putString("package", context.getPackageName());
        intent.putExtra(":settings:show_fragment_args", extraShowFragmentArguments);
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    @Nullable
    static Intent getHuaWeiMobileManagerAppIntent(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(EMUI_MOBILE_MANAGER_APP_PACKAGE_NAME);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    @Nullable
    static Intent getXiaoMiMobileManagerAppIntent(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(MIUI_MOBILE_MANAGER_APP_PACKAGE_NAME);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    @Nullable
    static Intent getOppoSafeCenterAppIntent(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(COLOR_OS_SAFE_CENTER_APP_PACKAGE_NAME_1);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        intent = context.getPackageManager().getLaunchIntentForPackage(COLOR_OS_SAFE_CENTER_APP_PACKAGE_NAME_2);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        intent = context.getPackageManager().getLaunchIntentForPackage(COLOR_OS_SAFE_CENTER_APP_PACKAGE_NAME_3);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    @Nullable
    static Intent getVivoMobileManagerAppIntent(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(ORIGIN_OS_MOBILE_MANAGER_APP_PACKAGE_NAME);
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }

    static Intent getApplicationDetailsIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        intent = new Intent("android.settings.APPLICATION_SETTINGS");
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        intent = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return PermissionIntentManager.getAndroidSettingAppIntent(context);
    }

    @Nullable
    static Intent getAndroidSettingAppIntent(Context context) {
        Intent intent = new Intent("android.settings.SETTINGS");
        if (PermissionUtils.areActivityIntent(context, intent)) {
            return intent;
        }
        return null;
    }
}

