/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.PermissionDelegateImplV29;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=30)
class PermissionDelegateImplV30
extends PermissionDelegateImplV29 {
    PermissionDelegateImplV30() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            return PermissionDelegateImplV30.isGrantedManageStoragePermission();
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isPermissionPermanentDenied(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            return false;
        }
        return super.isPermissionPermanentDenied(activity, permission2);
    }

    @Override
    public Intent getPermissionIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            return PermissionDelegateImplV30.getManageStoragePermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    private static boolean isGrantedManageStoragePermission() {
        return Environment.isExternalStorageManager();
    }

    private static Intent getManageStoragePermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

