/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV14;
import com.hjq.permissions.PermissionDelegateImplV18;
import com.hjq.permissions.PermissionDelegateImplV19;
import com.hjq.permissions.PermissionDelegateImplV21;
import com.hjq.permissions.PermissionDelegateImplV23;
import com.hjq.permissions.PermissionDelegateImplV26;
import com.hjq.permissions.PermissionDelegateImplV28;
import com.hjq.permissions.PermissionDelegateImplV29;
import com.hjq.permissions.PermissionDelegateImplV30;
import com.hjq.permissions.PermissionDelegateImplV31;
import com.hjq.permissions.PermissionDelegateImplV33;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

final class PermissionApi {
    @NonNull
    private static final PermissionDelegate DELEGATE = AndroidVersion.isAndroid13() ? new PermissionDelegateImplV33() : (AndroidVersion.isAndroid12() ? new PermissionDelegateImplV31() : (AndroidVersion.isAndroid11() ? new PermissionDelegateImplV30() : (AndroidVersion.isAndroid10() ? new PermissionDelegateImplV29() : (AndroidVersion.isAndroid9() ? new PermissionDelegateImplV28() : (AndroidVersion.isAndroid8() ? new PermissionDelegateImplV26() : (AndroidVersion.isAndroid6() ? new PermissionDelegateImplV23() : (AndroidVersion.isAndroid5() ? new PermissionDelegateImplV21() : (AndroidVersion.isAndroid4_4() ? new PermissionDelegateImplV19() : (AndroidVersion.isAndroid4_3() ? new PermissionDelegateImplV18() : new PermissionDelegateImplV14())))))))));

    PermissionApi() {
    }

    static boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        return DELEGATE.isGrantedPermission(context, permission2);
    }

    static boolean isPermissionPermanentDenied(@NonNull Activity activity, @NonNull String permission2) {
        return DELEGATE.isPermissionPermanentDenied(activity, permission2);
    }

    static Intent getPermissionIntent(@NonNull Context context, @NonNull String permission2) {
        return DELEGATE.getPermissionIntent(context, permission2);
    }

    static boolean isSpecialPermission(@NonNull String permission2) {
        return PermissionUtils.isSpecialPermission(permission2);
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (!PermissionApi.isSpecialPermission(permission2)) continue;
            return true;
        }
        return false;
    }

    static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    static List<String> getGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> grantedPermission = new ArrayList<String>(permissions.size());
        for (String permission2 : permissions) {
            if (!PermissionApi.isGrantedPermission(context, permission2)) continue;
            grantedPermission.add(permission2);
        }
        return grantedPermission;
    }

    static List<String> getDeniedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> deniedPermission = new ArrayList<String>(permissions.size());
        for (String permission2 : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission2)) continue;
            deniedPermission.add(permission2);
        }
        return deniedPermission;
    }

    static boolean isPermissionPermanentDenied(@NonNull Activity activity, @NonNull List<String> permissions) {
        for (String permission2 : permissions) {
            if (!PermissionApi.isPermissionPermanentDenied(activity, permission2)) continue;
            return true;
        }
        return false;
    }

    static List<String> getDeniedPermissions(@NonNull List<String> permissions, @NonNull int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions.get(i));
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermissions(@NonNull List<String> permissions, @NonNull int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions.get(i));
        }
        return grantedPermissions;
    }
}

