/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionUtils;

final class NotificationListenerPermissionCompat {
    private static final String SETTING_ENABLED_NOTIFICATION_LISTENERS = "enabled_notification_listeners";

    NotificationListenerPermissionCompat() {
    }

    static boolean isGrantedPermission(@NonNull Context context) {
        String[] components;
        if (!AndroidVersion.isAndroid4_3()) {
            return true;
        }
        String enabledNotificationListeners = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)SETTING_ENABLED_NOTIFICATION_LISTENERS);
        if (TextUtils.isEmpty((CharSequence)enabledNotificationListeners)) {
            return false;
        }
        for (String component : components = enabledNotificationListeners.split(":")) {
            ComponentName componentName = ComponentName.unflattenFromString((String)component);
            if (!TextUtils.equals((CharSequence)componentName.getPackageName(), (CharSequence)context.getPackageName())) continue;
            String className = componentName.getClassName();
            try {
                Class.forName(className);
                return true;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static Intent getPermissionIntent(@NonNull Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid11()) {
            AndroidManifestInfo androidManifestInfo = PermissionUtils.getAndroidManifestInfo(context);
            AndroidManifestInfo.ServiceInfo serviceInfo = null;
            if (androidManifestInfo != null) {
                for (AndroidManifestInfo.ServiceInfo info : androidManifestInfo.serviceInfoList) {
                    if (!TextUtils.equals((CharSequence)info.permission, (CharSequence)"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) continue;
                    if (serviceInfo != null) {
                        serviceInfo = null;
                        break;
                    }
                    serviceInfo = info;
                }
            }
            if (serviceInfo != null) {
                intent = new Intent("android.settings.NOTIFICATION_LISTENER_DETAIL_SETTINGS");
                intent.putExtra("android.provider.extra.NOTIFICATION_LISTENER_COMPONENT_NAME", new ComponentName(context, serviceInfo.name).flattenToString());
                if (!PermissionUtils.areActivityIntent(context, intent)) {
                    intent = null;
                }
            }
        }
        if (intent == null) {
            intent = AndroidVersion.isAndroid5_1() ? new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS") : new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

