/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionUtils;
import java.util.Set;

@RequiresApi(api=14)
class PermissionDelegateImplV14
implements PermissionDelegate {
    PermissionDelegateImplV14() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE")) {
            return PermissionDelegateImplV14.isGrantedNotifyPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            return PermissionDelegateImplV14.isGrantedPackagePermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) {
            return PermissionDelegateImplV14.isGrantedNotificationListenerPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return PermissionDelegateImplV14.isGrantedVpnPermission(context);
        }
        if (!AndroidVersion.isAndroid13() && PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            return PermissionDelegateImplV14.isGrantedNotifyPermission(context);
        }
        return true;
    }

    @Override
    public boolean isPermissionPermanentDenied(@NonNull Activity activity, @NonNull String permission2) {
        return false;
    }

    @Override
    public Intent getPermissionIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE")) {
            return PermissionDelegateImplV14.getNotifyPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS")) {
            return PermissionDelegateImplV14.getPackagePermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) {
            return PermissionDelegateImplV14.getNotificationListenerIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) {
            return PermissionDelegateImplV14.getVpnPermissionIntent(context);
        }
        if (!AndroidVersion.isAndroid13() && PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            return PermissionDelegateImplV14.getNotifyPermissionIntent(context);
        }
        return PermissionUtils.getApplicationDetailsIntent(context);
    }

    private static boolean isGrantedNotifyPermission(@NonNull Context context) {
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }

    private static Intent getNotifyPermissionIntent(@NonNull Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid8()) {
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedNotificationListenerPermission(@NonNull Context context) {
        if (AndroidVersion.isAndroid4_3()) {
            Set packageNames = NotificationManagerCompat.getEnabledListenerPackages((Context)context);
            return packageNames.contains(context.getPackageName());
        }
        return true;
    }

    private static Intent getNotificationListenerIntent(@NonNull Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid11()) {
            AndroidManifestInfo androidManifestInfo = PermissionUtils.getAndroidManifestInfo(context);
            AndroidManifestInfo.ServiceInfo serviceInfo = null;
            if (androidManifestInfo != null) {
                for (AndroidManifestInfo.ServiceInfo info : androidManifestInfo.serviceInfoList) {
                    if (!TextUtils.equals((CharSequence)info.permission, (CharSequence)"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) continue;
                    if (serviceInfo != null) {
                        serviceInfo = null;
                        break;
                    }
                    serviceInfo = info;
                }
            }
            if (serviceInfo != null) {
                intent = new Intent("android.settings.NOTIFICATION_LISTENER_DETAIL_SETTINGS");
                intent.putExtra("android.provider.extra.NOTIFICATION_LISTENER_COMPONENT_NAME", new ComponentName(context, serviceInfo.name).flattenToString());
                if (!PermissionUtils.areActivityIntent(context, intent)) {
                    intent = null;
                }
            }
        }
        if (intent == null) {
            intent = AndroidVersion.isAndroid5_1() ? new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS") : new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedPackagePermission(@NonNull Context context) {
        if (AndroidVersion.isAndroid5()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            int mode = AndroidVersion.isAndroid10() ? appOps.unsafeCheckOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName()) : appOps.checkOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName());
            return mode == 0;
        }
        return true;
    }

    private static Intent getPackagePermissionIntent(@NonNull Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid5()) {
            intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            if (AndroidVersion.isAndroid10()) {
                intent.setData(PermissionUtils.getPackageNameUri(context));
            }
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedVpnPermission(@NonNull Context context) {
        return VpnService.prepare((Context)context) == null;
    }

    private static Intent getVpnPermissionIntent(@NonNull Context context) {
        Intent intent = VpnService.prepare((Context)context);
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

