/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

final class PermissionChecker {
    PermissionChecker() {
    }

    static boolean checkActivityStatus(@Nullable Activity activity, boolean checkMode) {
        if (activity == null) {
            if (checkMode) {
                throw new IllegalArgumentException("The instance of the context must be an activity object");
            }
            return false;
        }
        if (activity.isFinishing()) {
            if (checkMode) {
                throw new IllegalStateException("The activity has been finishing, please manually determine the status of the activity");
            }
            return false;
        }
        if (AndroidVersion.isAndroid4_2() && activity.isDestroyed()) {
            if (checkMode) {
                throw new IllegalStateException("The activity has been destroyed, please manually determine the status of the activity");
            }
            return false;
        }
        return true;
    }

    static boolean checkPermissionArgument(@Nullable List<String> requestPermissions, boolean checkMode) {
        if (requestPermissions == null || requestPermissions.isEmpty()) {
            if (checkMode) {
                throw new IllegalArgumentException("The requested permission cannot be empty");
            }
            return false;
        }
        if (AndroidVersion.getAndroidVersionCode() > 33) {
            return true;
        }
        if (checkMode) {
            ArrayList<String> allPermissions = new ArrayList<String>();
            Field[] fields = Permission.class.getDeclaredFields();
            if (fields.length == 0) {
                return true;
            }
            for (Field field : fields) {
                if (!String.class.equals(field.getType())) continue;
                try {
                    allPermissions.add((String)field.get(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            for (String permission2 : requestPermissions) {
                if (PermissionUtils.containsPermission(allPermissions, permission2)) continue;
                throw new IllegalArgumentException("The " + permission2 + " is not a dangerous permission or special permission, please do not request dynamically");
            }
        }
        return true;
    }

    static void checkMediaLocationPermission(@NonNull Context context, @NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE") || PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) continue;
            throw new IllegalArgumentException("Because it includes access media location permissions, do not apply for permissions unrelated to access media location");
        }
        if (AndroidVersion.getTargetSdkVersionCode(context) >= 33) {
            if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("You must add android.permission.READ_MEDIA_IMAGES or android.permission.MANAGE_EXTERNAL_STORAGE rights to apply for android.permission.ACCESS_MEDIA_LOCATION rights");
            }
        } else if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("You must add android.permission.READ_EXTERNAL_STORAGE or android.permission.MANAGE_EXTERNAL_STORAGE rights to apply for android.permission.ACCESS_MEDIA_LOCATION rights");
        }
    }

    static void checkStoragePermission(@NonNull Context context, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!(PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            return;
        }
        if (AndroidVersion.getTargetSdkVersionCode(context) >= 33 && PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("When targetSdkVersion >= 33 should use android.permission.READ_MEDIA_IMAGES, android.permission.READ_MEDIA_VIDEO, android.permission.READ_MEDIA_AUDIO instead of android.permission.READ_EXTERNAL_STORAGE");
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        AndroidManifestInfo.ApplicationInfo applicationInfo = androidManifestInfo.applicationInfo;
        if (applicationInfo == null) {
            return;
        }
        boolean scopedStorage = PermissionUtils.isScopedStorage(context);
        int targetSdkVersion = AndroidVersion.getTargetSdkVersionCode(context);
        boolean requestLegacyExternalStorage = applicationInfo.requestLegacyExternalStorage;
        if (!(targetSdkVersion < 29 || requestLegacyExternalStorage || !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && scopedStorage)) {
            throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
        }
        if (targetSdkVersion >= 30 && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && !scopedStorage) {
            throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use android.permission.MANAGE_EXTERNAL_STORAGE to apply for permission");
        }
    }

    static void checkBodySensorsPermission(@NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS")) {
            throw new IllegalArgumentException("Applying for background sensor permissions must contain android.permission.BODY_SENSORS");
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                throw new IllegalArgumentException("Applying for permissions android.permission.BODY_SENSORS_BACKGROUND and android.permission.ACCESS_BACKGROUND_LOCATION at the same time is not supported");
            }
            if (!PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) continue;
            throw new IllegalArgumentException("Applying for permissions android.permission.BODY_SENSORS_BACKGROUND and android.permission.ACCESS_MEDIA_LOCATION at the same time is not supported");
        }
    }

    static void checkLocationPermission(@NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalArgumentException("Applying for background positioning permissions must include android.permission.ACCESS_FINE_LOCATION");
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_FINE_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_COARSE_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) continue;
            throw new IllegalArgumentException("Because it includes background location permissions, do not apply for permissions unrelated to location");
        }
    }

    static void checkNearbyDevicesPermission(@NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_SCAN") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.NEARBY_WIFI_DEVICES")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.PermissionInfo> permissionInfoList = androidManifestInfo.permissionInfoList;
        for (AndroidManifestInfo.PermissionInfo permissionInfo : permissionInfoList) {
            if (!PermissionUtils.equalsPermission(permissionInfo.name, "android.permission.BLUETOOTH_SCAN") && !PermissionUtils.equalsPermission(permissionInfo.name, "android.permission.NEARBY_WIFI_DEVICES") || permissionInfo.neverForLocation()) continue;
            String maxSdkVersionString = permissionInfo.maxSdkVersion != Integer.MAX_VALUE ? "android:maxSdkVersion=\"" + permissionInfo.maxSdkVersion + "\" " : "";
            throw new IllegalArgumentException("If your app doesn't use " + permissionInfo.name + " to get physical location, please change the <uses-permission android:name=\"" + permissionInfo.name + "\" " + maxSdkVersionString + "/> node in the manifest file to <uses-permission android:name=\"" + permissionInfo.name + "\" android:usesPermissionFlags=\"neverForLocation\" " + maxSdkVersionString + "/> node, if your app need use " + permissionInfo.name + " to get physical location, also need to add " + "android.permission.ACCESS_FINE_LOCATION" + " permissions");
        }
    }

    static void checkNotificationListenerPermission(@NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.ServiceInfo> serviceInfoList = androidManifestInfo.serviceInfoList;
        for (int i = 0; i < serviceInfoList.size(); ++i) {
            String permission2 = serviceInfoList.get((int)i).permission;
            if (!TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) continue;
            return;
        }
        throw new IllegalArgumentException("No service registered permission attribute, please register <service android:permission=\"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE\" > in AndroidManifest.xml");
    }

    static void checkPictureInPicturePermission(@NonNull Activity activity, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.PICTURE_IN_PICTURE")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.ActivityInfo> activityInfoList = androidManifestInfo.activityInfoList;
        for (int i = 0; i < activityInfoList.size(); ++i) {
            boolean supportsPictureInPicture = activityInfoList.get((int)i).supportsPictureInPicture;
            if (!supportsPictureInPicture) continue;
            return;
        }
        String activityName = activity.getClass().getName().replace(activity.getPackageName(), "");
        throw new IllegalArgumentException("No activity registered supportsPictureInPicture attribute, please register \n<activity android:name=\"" + activityName + "\" android:supportsPictureInPicture=\"true\" > in AndroidManifest.xml");
    }

    static void checkTargetSdkVersion(@NonNull Context context, @NonNull List<String> requestPermissions) {
        int targetSdkMinVersion = PermissionUtils.containsPermission(requestPermissions, "android.permission.POST_NOTIFICATIONS") || PermissionUtils.containsPermission(requestPermissions, "android.permission.NEARBY_WIFI_DEVICES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO") ? 33 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_SCAN") || PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_ADVERTISE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.SCHEDULE_EXACT_ALARM") ? 31 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") ? 30 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_BACKGROUND_LOCATION") || PermissionUtils.containsPermission(requestPermissions, "android.permission.ACTIVITY_RECOGNITION") || PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION") ? 29 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCEPT_HANDOVER") ? 28 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.REQUEST_INSTALL_PACKAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.ANSWER_PHONE_CALLS") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_PHONE_NUMBERS") || PermissionUtils.containsPermission(requestPermissions, "android.permission.PICTURE_IN_PICTURE") ? 26 : 23)))));
        if (AndroidVersion.getTargetSdkVersionCode(context) < targetSdkMinVersion) {
            throw new RuntimeException("The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more, if you do not want to upgrade targetSdkVersion, please apply with the old permissions");
        }
    }

    static void checkManifestPermissions(@NonNull Context context, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.PermissionInfo> permissionInfoList = androidManifestInfo.permissionInfoList;
        if (permissionInfoList.isEmpty()) {
            throw new IllegalStateException("No permissions are registered in the AndroidManifest.xml file");
        }
        int minSdkVersion = AndroidVersion.isAndroid7() ? context.getApplicationInfo().minSdkVersion : (androidManifestInfo.usesSdkInfo != null ? androidManifestInfo.usesSdkInfo.minSdkVersion : 23);
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) continue;
            if (PermissionUtils.equalsPermission(permission2, "android.permission.BODY_SENSORS_BACKGROUND")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BODY_SENSORS");
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                if (AndroidVersion.getTargetSdkVersionCode(context) >= 31) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 30);
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_COARSE_LOCATION");
                    continue;
                }
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION");
                continue;
            }
            if (minSdkVersion < 33) {
                if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_AUDIO")) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.READ_EXTERNAL_STORAGE", 32);
                    continue;
                }
                if (PermissionUtils.equalsPermission(permission2, "android.permission.NEARBY_WIFI_DEVICES")) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 32);
                    continue;
                }
            }
            if (minSdkVersion < 31) {
                if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BLUETOOTH_ADMIN", 30);
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 30);
                    continue;
                }
                if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT")) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BLUETOOTH", 30);
                    continue;
                }
                if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BLUETOOTH_ADMIN", 30);
                    continue;
                }
            }
            if (minSdkVersion < 30 && PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.READ_EXTERNAL_STORAGE", 29);
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.WRITE_EXTERNAL_STORAGE", 29);
                continue;
            }
            if (minSdkVersion < 26 && PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.READ_PHONE_STATE", 25);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.QUERY_ALL_PACKAGES");
            }
            PermissionChecker.checkManifestPermission(permissionInfoList, permission2);
        }
    }

    static void checkManifestPermission(@NonNull List<AndroidManifestInfo.PermissionInfo> permissionInfoList, String checkPermission) {
        PermissionChecker.checkManifestPermission(permissionInfoList, checkPermission, Integer.MAX_VALUE);
    }

    static void checkManifestPermission(@NonNull List<AndroidManifestInfo.PermissionInfo> permissionInfoList, String checkPermission, int maxSdkVersion) {
        AndroidManifestInfo.PermissionInfo permissionInfo = null;
        for (AndroidManifestInfo.PermissionInfo info : permissionInfoList) {
            if (!TextUtils.equals((CharSequence)info.name, (CharSequence)checkPermission)) continue;
            permissionInfo = info;
            break;
        }
        if (permissionInfo == null) {
            throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" />");
        }
        int manifestMaxSdkVersion = permissionInfo.maxSdkVersion;
        if (manifestMaxSdkVersion < maxSdkVersion) {
            throw new IllegalArgumentException("The AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" /> does not meet the requirements, " + (maxSdkVersion != Integer.MAX_VALUE ? "the minimum requirement for maxSdkVersion is " + maxSdkVersion : "please delete the android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" attribute"));
        }
    }

    static void optimizeDeprecatedPermission(@NonNull List<String> requestPermissions) {
        if (!AndroidVersion.isAndroid13()) {
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.POST_NOTIFICATIONS") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.NOTIFICATION_SERVICE")) {
                requestPermissions.add("android.permission.NOTIFICATION_SERVICE");
            }
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.NEARBY_WIFI_DEVICES") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
                requestPermissions.add("android.permission.ACCESS_FINE_LOCATION");
            }
            if ((PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO")) && !PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid12() && PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_SCAN") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            requestPermissions.add("android.permission.ACCESS_FINE_LOCATION");
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("If you have applied for MANAGE_EXTERNAL_STORAGE permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions");
            }
            if (!AndroidVersion.isAndroid11()) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
                requestPermissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid10() && PermissionUtils.containsPermission(requestPermissions, "android.permission.ACTIVITY_RECOGNITION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS")) {
            requestPermissions.add("android.permission.BODY_SENSORS");
        }
        if (!AndroidVersion.isAndroid8() && PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_PHONE_NUMBERS") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_PHONE_STATE")) {
            requestPermissions.add("android.permission.READ_PHONE_STATE");
        }
    }
}

