/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.IPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionChecker;
import com.hjq.permissions.PermissionPageFragment;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static IPermissionInterceptor sInterceptor;
    private static Boolean sCheckMode;
    @NonNull
    private List<String> mPermissions = new ArrayList<String>();
    @Nullable
    private final Context mContext;
    @Nullable
    private IPermissionInterceptor mInterceptor;
    @Nullable
    private Boolean mCheckMode;

    public static XXPermissions with(@NonNull Context context) {
        return new XXPermissions(context);
    }

    public static XXPermissions with(@NonNull Fragment fragment) {
        return XXPermissions.with((Context)fragment.getActivity());
    }

    public static XXPermissions with(@NonNull android.support.v4.app.Fragment fragment) {
        return XXPermissions.with((Context)fragment.getActivity());
    }

    public static void setCheckMode(boolean checkMode) {
        sCheckMode = checkMode;
    }

    public static void setInterceptor(IPermissionInterceptor interceptor) {
        sInterceptor = interceptor;
    }

    public static IPermissionInterceptor getInterceptor() {
        if (sInterceptor == null) {
            sInterceptor = new IPermissionInterceptor(){};
        }
        return sInterceptor;
    }

    private XXPermissions(@Nullable Context context) {
        this.mContext = context;
    }

    public XXPermissions permission(String ... permissions) {
        return this.permission(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions permission(String[] ... permissions) {
        return this.permission(PermissionUtils.asArrayLists(permissions));
    }

    public XXPermissions permission(@Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this;
        }
        for (String permission2 : permissions) {
            if (PermissionUtils.containsPermission(this.mPermissions, permission2)) continue;
            this.mPermissions.add(permission2);
        }
        return this;
    }

    public XXPermissions interceptor(@Nullable IPermissionInterceptor interceptor) {
        this.mInterceptor = interceptor;
        return this;
    }

    public XXPermissions unchecked() {
        this.mCheckMode = false;
        return this;
    }

    public void request(@Nullable OnPermissionCallback callback) {
        if (this.mContext == null) {
            return;
        }
        if (this.mInterceptor == null) {
            this.mInterceptor = XXPermissions.getInterceptor();
        }
        Context context = this.mContext;
        IPermissionInterceptor interceptor = this.mInterceptor;
        ArrayList<String> permissions = new ArrayList<String>(this.mPermissions);
        boolean checkMode = this.isCheckMode(context);
        Activity activity = PermissionUtils.findActivity(context);
        if (!PermissionChecker.checkActivityStatus(activity, checkMode)) {
            return;
        }
        if (!PermissionChecker.checkPermissionArgument(permissions, checkMode)) {
            return;
        }
        if (checkMode) {
            AndroidManifestInfo androidManifestInfo = PermissionUtils.getAndroidManifestInfo(context);
            PermissionChecker.checkMediaLocationPermission(context, permissions);
            PermissionChecker.checkStoragePermission(context, permissions, androidManifestInfo);
            PermissionChecker.checkBodySensorsPermission(permissions);
            PermissionChecker.checkLocationPermission(permissions);
            PermissionChecker.checkPictureInPicturePermission(activity, permissions, androidManifestInfo);
            PermissionChecker.checkNotificationListenerPermission(permissions, androidManifestInfo);
            PermissionChecker.checkNearbyDevicesPermissions(permissions, androidManifestInfo);
            PermissionChecker.checkTargetSdkVersion(context, permissions);
            PermissionChecker.checkManifestPermissions(context, permissions, androidManifestInfo);
        }
        PermissionChecker.optimizeDeprecatedPermission(permissions);
        if (PermissionApi.isGrantedPermissions(context, permissions)) {
            if (callback != null) {
                interceptor.grantedPermissionRequest(activity, permissions, permissions, true, callback);
                interceptor.finishPermissionRequest(activity, permissions, true, callback);
            }
            return;
        }
        interceptor.launchPermissionRequest(activity, permissions, callback);
    }

    public boolean revokeOnKill() {
        if (this.mContext == null) {
            return false;
        }
        Context context = this.mContext;
        List<String> permissions = this.mPermissions;
        if (permissions.isEmpty()) {
            return false;
        }
        if (!AndroidVersion.isAndroid13()) {
            return false;
        }
        try {
            if (permissions.size() == 1) {
                context.revokeSelfPermissionOnKill(permissions.get(0));
            } else {
                context.revokeSelfPermissionsOnKill(permissions);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            if (this.isCheckMode(context)) {
                throw e;
            }
            e.printStackTrace();
            return false;
        }
    }

    private boolean isCheckMode(@NonNull Context context) {
        if (this.mCheckMode == null) {
            if (sCheckMode == null) {
                sCheckMode = PermissionUtils.isDebugMode(context);
            }
            this.mCheckMode = sCheckMode;
        }
        return this.mCheckMode;
    }

    public static boolean isGranted(@NonNull Context context, String ... permissions) {
        return XXPermissions.isGranted(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGranted(@NonNull Context context, String[] ... permissions) {
        return XXPermissions.isGranted(context, PermissionUtils.asArrayLists(permissions));
    }

    public static boolean isGranted(@NonNull Context context, @NonNull List<String> permissions) {
        return PermissionApi.isGrantedPermissions(context, permissions);
    }

    public static List<String> getDenied(@NonNull Context context, String ... permissions) {
        return XXPermissions.getDenied(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<String> getDenied(@NonNull Context context, String[] ... permissions) {
        return XXPermissions.getDenied(context, PermissionUtils.asArrayLists(permissions));
    }

    public static List<String> getDenied(@NonNull Context context, @NonNull List<String> permissions) {
        return PermissionApi.getDeniedPermissions(context, permissions);
    }

    public static boolean isSpecial(@NonNull String permission2) {
        return PermissionApi.isSpecialPermission(permission2);
    }

    public static boolean containsSpecial(String ... permissions) {
        return XXPermissions.containsSpecial(PermissionUtils.asArrayList(permissions));
    }

    public static boolean containsSpecial(@NonNull List<String> permissions) {
        return PermissionApi.containsSpecialPermission(permissions);
    }

    public static boolean isPermanentDenied(@NonNull Activity activity, String ... permissions) {
        return XXPermissions.isPermanentDenied(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isPermanentDenied(@NonNull Activity activity, String[] ... permissions) {
        return XXPermissions.isPermanentDenied(activity, PermissionUtils.asArrayLists(permissions));
    }

    public static boolean isPermanentDenied(@NonNull Activity activity, @NonNull List<String> permissions) {
        return PermissionApi.isPermissionPermanentDenied(activity, permissions);
    }

    public static void startPermissionActivity(@NonNull Context context) {
        XXPermissions.startPermissionActivity(context, new ArrayList<String>(0));
    }

    public static void startPermissionActivity(@NonNull Context context, String ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Context context, String[] ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull Context context, @NonNull List<String> permissions) {
        Activity activity = PermissionUtils.findActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity(activity, permissions);
            return;
        }
        Intent intent = PermissionUtils.getSmartPermissionIntent(context, permissions);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public static void startPermissionActivity(@NonNull Activity activity) {
        XXPermissions.startPermissionActivity(activity, new ArrayList<String>(0));
    }

    public static void startPermissionActivity(@NonNull Activity activity, String ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Activity activity, String[] ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<String> permissions) {
        XXPermissions.startPermissionActivity(activity, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<String> permissions, int requestCode) {
        Intent intent = PermissionUtils.getSmartPermissionIntent((Context)activity, permissions);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull String permission2, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull String[] permissions, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        if (permissions.isEmpty()) {
            activity.startActivity(PermissionUtils.getApplicationDetailsIntent((Context)activity));
            return;
        }
        PermissionPageFragment.beginRequest(activity, (ArrayList)permissions, callback);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment) {
        XXPermissions.startPermissionActivity(fragment, new ArrayList<String>(0));
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, String ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, String[] ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull List<String> permissions) {
        XXPermissions.startPermissionActivity(fragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull List<String> permissions, int requestCode) {
        Activity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        if (permissions.isEmpty()) {
            fragment.startActivity(PermissionUtils.getApplicationDetailsIntent((Context)activity));
            return;
        }
        Intent intent = PermissionUtils.getSmartPermissionIntent((Context)activity, permissions);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull String permission2, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull String[] permissions, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(@NonNull Fragment fragment, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        Activity activity = fragment.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (AndroidVersion.isAndroid4_2() && activity.isDestroyed()) {
            return;
        }
        if (permissions.isEmpty()) {
            fragment.startActivity(PermissionUtils.getApplicationDetailsIntent((Context)activity));
            return;
        }
        PermissionPageFragment.beginRequest(activity, (ArrayList)permissions, callback);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment) {
        XXPermissions.startPermissionActivity(fragment, new ArrayList<String>());
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, String ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, String[] ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, @NonNull List<String> permissions) {
        XXPermissions.startPermissionActivity(fragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, @NonNull List<String> permissions, int requestCode) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        if (permissions.isEmpty()) {
            fragment.startActivity(PermissionUtils.getApplicationDetailsIntent((Context)activity));
            return;
        }
        Intent intent = PermissionUtils.getSmartPermissionIntent((Context)activity, permissions);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, @NonNull String permission2, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, @NonNull String[] permissions, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment fragment, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (AndroidVersion.isAndroid4_2() && activity.isDestroyed()) {
            return;
        }
        if (permissions.isEmpty()) {
            fragment.startActivity(PermissionUtils.getApplicationDetailsIntent((Context)activity));
            return;
        }
        PermissionPageFragment.beginRequest((Activity)activity, (ArrayList)permissions, callback);
    }
}

