/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionFragment;
import java.util.ArrayList;
import java.util.List;

public interface IPermissionInterceptor {
    default public void launchPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, @Nullable OnPermissionCallback callback) {
        PermissionFragment.launch(activity, new ArrayList<String>(allPermissions), this, callback);
    }

    default public void grantedPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, @NonNull List<String> grantedPermissions, boolean all, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        callback.onGranted(grantedPermissions, all);
    }

    default public void deniedPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, @NonNull List<String> deniedPermissions, boolean never, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        callback.onDenied(deniedPermissions, never);
    }

    default public void finishPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, boolean skipRequest, @Nullable OnPermissionCallback callback) {
    }
}

