/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionApi;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    PermissionUtils() {
    }

    public static boolean isSpecialPermission(String permission2) {
        return PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE") || PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW") || PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_SETTINGS") || PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.PACKAGE_USAGE_STATS") || PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM") || PermissionUtils.equalsPermission(permission2, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_NOTIFICATION_POLICY") || PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS") || PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE");
    }

    @RequiresApi(api=23)
    public static boolean checkSelfPermission(Context context, String permission2) {
        return context.checkSelfPermission(permission2) == 0;
    }

    @RequiresApi(api=23)
    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission2) {
        if (AndroidVersion.getAndroidVersionCode() == 31) {
            try {
                PackageManager packageManager = activity.getApplication().getPackageManager();
                Method method = PackageManager.class.getMethod("shouldShowRequestPermissionRationale", String.class);
                return (Boolean)method.invoke((Object)packageManager, permission2);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return activity.shouldShowRequestPermissionRationale(permission2);
    }

    static void postDelayed(Runnable runnable, long delayMillis) {
        HANDLER.postDelayed(runnable, delayMillis);
    }

    static void postActivityResult(List<String> permissions, Runnable runnable) {
        long delayMillis = AndroidVersion.isAndroid11() ? 200L : 300L;
        String manufacturer = Build.MANUFACTURER.toLowerCase();
        if (manufacturer.contains("huawei")) {
            delayMillis = AndroidVersion.isAndroid8() ? 300L : 500L;
        } else if (manufacturer.contains("xiaomi") && AndroidVersion.isAndroid11() && PermissionUtils.containsPermission(permissions, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            delayMillis = 1000L;
        }
        HANDLER.postDelayed(runnable, delayMillis);
    }

    static String getAndroidNamespace() {
        return "http://schemas.android.com/apk/res/android";
    }

    static boolean isDebugMode(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashMap<String, Integer> getManifestPermissions(Context context) {
        HashMap<String, Integer> manifestPermissions = new HashMap<String, Integer>();
        XmlResourceParser parser = PermissionUtils.parseAndroidManifest(context);
        if (parser != null) {
            try {
                do {
                    if (parser.getEventType() != 2 || !"uses-permission".equals(parser.getName())) continue;
                    manifestPermissions.put(parser.getAttributeValue(PermissionUtils.getAndroidNamespace(), "name"), parser.getAttributeIntValue(PermissionUtils.getAndroidNamespace(), "maxSdkVersion", Integer.MAX_VALUE));
                } while (parser.next() != 1);
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
            finally {
                parser.close();
            }
        }
        if (manifestPermissions.isEmpty()) {
            try {
                String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
                if (requestedPermissions != null) {
                    for (String permission2 : requestedPermissions) {
                        manifestPermissions.put(permission2, Integer.MAX_VALUE);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return manifestPermissions;
    }

    static void optimizePermissionResults(Activity activity, String[] permissions, int[] grantResults) {
        for (int i = 0; i < permissions.length; ++i) {
            boolean recheck = false;
            String permission2 = permissions[i];
            if (PermissionApi.isSpecialPermission(permission2)) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid13() && (PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS") || PermissionUtils.equalsPermission(permission2, "android.permission.NEARBY_WIFI_DEVICES") || PermissionUtils.equalsPermission(permission2, "android.permission.BODY_SENSORS_BACKGROUND") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_AUDIO"))) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid12() && (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE"))) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid10() && (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION"))) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid9() && PermissionUtils.equalsPermission(permission2, "android.permission.ACCEPT_HANDOVER")) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid8() && (PermissionUtils.equalsPermission(permission2, "android.permission.ANSWER_PHONE_CALLS") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS"))) {
                recheck = true;
            }
            if (!recheck) continue;
            grantResults[i] = PermissionApi.isGrantedPermission((Context)activity, permission2) ? 0 : -1;
        }
    }

    static <T> ArrayList<T> asArrayList(T ... array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        if (array == null || array.length == 0) {
            return list;
        }
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    static <T> ArrayList<T> asArrayLists(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (arrays == null || arrays.length == 0) {
            return list;
        }
        for (T[] ts : arrays) {
            list.addAll(PermissionUtils.asArrayList(ts));
        }
        return list;
    }

    static Activity findActivity(Context context) {
        do {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }

    @SuppressLint(value={"PrivateApi"})
    static int findApkPathCookie(Context context, String apkPath) {
        Integer cookie;
        AssetManager assets = context.getAssets();
        try {
            if (AndroidVersion.getTargetSdkVersionCode(context) >= 28 && AndroidVersion.getAndroidVersionCode() >= 28 && AndroidVersion.getAndroidVersionCode() < 30) {
                Method metaGetDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, Class[].class);
                metaGetDeclaredMethod.setAccessible(true);
                Method findCookieForPathMethod = (Method)metaGetDeclaredMethod.invoke(AssetManager.class, "findCookieForPath", new Class[]{String.class});
                if (findCookieForPathMethod != null) {
                    findCookieForPathMethod.setAccessible(true);
                    cookie = (Integer)findCookieForPathMethod.invoke((Object)context.getAssets(), apkPath);
                    if (cookie != null) {
                        return cookie;
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        try {
            Method addAssetPathMethod = assets.getClass().getDeclaredMethod("addAssetPath", String.class);
            cookie = (Integer)addAssetPathMethod.invoke((Object)assets, apkPath);
            if (cookie != null) {
                return cookie;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static XmlResourceParser parseAndroidManifest(Context context) {
        int cookie = PermissionUtils.findApkPathCookie(context, context.getApplicationInfo().sourceDir);
        if (cookie == 0) {
            return null;
        }
        try {
            XmlResourceParser parser = context.getAssets().openXmlResourceParser(cookie, "AndroidManifest.xml");
            do {
                if (parser.getEventType() != 2 || !"manifest".equals(parser.getName()) || !TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)parser.getAttributeValue(null, "package"))) continue;
                return parser;
            } while (parser.next() != 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    static boolean isScopedStorage(Context context) {
        try {
            String metaKey = "ScopedStorage";
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return Boolean.parseBoolean(String.valueOf(metaData.get(metaKey)));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    @SuppressLint(value={"SwitchIntDef"})
    static void lockActivityOrientation(Activity activity) {
        try {
            switch (activity.getResources().getConfiguration().orientation) {
                case 2: {
                    activity.setRequestedOrientation(PermissionUtils.isActivityReverse(activity) ? 8 : 0);
                    break;
                }
                case 1: {
                    activity.setRequestedOrientation(PermissionUtils.isActivityReverse(activity) ? 9 : 1);
                    break;
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    static boolean isActivityReverse(Activity activity) {
        int activityRotation = AndroidVersion.isAndroid11() ? activity.getDisplay().getRotation() : activity.getWindowManager().getDefaultDisplay().getRotation();
        switch (activityRotation) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static boolean areActivityIntent(Context context, Intent intent) {
        return !context.getPackageManager().queryIntentActivities(intent, 65536).isEmpty();
    }

    public static Intent getApplicationDetailsIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent) && !PermissionUtils.areActivityIntent(context, intent = new Intent("android.settings.APPLICATION_SETTINGS"))) {
            intent = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
        }
        return intent;
    }

    public static Uri getPackageNameUri(Context context) {
        return Uri.parse((String)("package:" + context.getPackageName()));
    }

    static Intent getSmartPermissionIntent(Context context, List<String> permissions) {
        if (permissions == null || permissions.isEmpty() || !PermissionApi.containsSpecialPermission(permissions)) {
            return PermissionUtils.getApplicationDetailsIntent(context);
        }
        switch (permissions.size()) {
            case 1: {
                return PermissionApi.getPermissionIntent(context, permissions.get(0));
            }
            case 2: {
                if (AndroidVersion.isAndroid13() || !PermissionUtils.containsPermission(permissions, "android.permission.NOTIFICATION_SERVICE") || !PermissionUtils.containsPermission(permissions, "android.permission.POST_NOTIFICATIONS")) break;
                return PermissionApi.getPermissionIntent(context, "android.permission.NOTIFICATION_SERVICE");
            }
            case 3: {
                if (!AndroidVersion.isAndroid11() || !PermissionUtils.containsPermission(permissions, "android.permission.MANAGE_EXTERNAL_STORAGE") || !PermissionUtils.containsPermission(permissions, "android.permission.READ_EXTERNAL_STORAGE") || !PermissionUtils.containsPermission(permissions, "android.permission.WRITE_EXTERNAL_STORAGE")) break;
                return PermissionApi.getPermissionIntent(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
            }
        }
        return PermissionUtils.getApplicationDetailsIntent(context);
    }

    static boolean equalsPermission(String permission1, String permission2) {
        if (permission1 == null || permission2 == null) {
            return false;
        }
        int length = permission1.length();
        if (length != permission2.length()) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (permission1.charAt(i) == permission2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean containsPermission(Collection<String> permissions, String permission2) {
        if (permissions == null || permissions.isEmpty() || permission2 == null) {
            return false;
        }
        for (String s : permissions) {
            if (!PermissionUtils.equalsPermission(s, permission2)) continue;
            return true;
        }
        return false;
    }
}

