/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV28;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=29)
class PermissionDelegateImplV29
extends PermissionDelegateImplV28 {
    PermissionDelegateImplV29() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return this.hasReadStoragePermission(context) && PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_MEDIA_LOCATION");
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (!AndroidVersion.isAndroid11() && PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionDelegateImplV29.isUseDeprecationExternalStorage()) {
            return false;
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isPermissionPermanentDenied(Activity activity, String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return this.hasReadStoragePermission((Context)activity) && !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (!AndroidVersion.isAndroid11() && PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionDelegateImplV29.isUseDeprecationExternalStorage()) {
            return true;
        }
        return super.isPermissionPermanentDenied(activity, permission2);
    }

    private static boolean isUseDeprecationExternalStorage() {
        return Environment.isExternalStorageLegacy();
    }

    private boolean hasReadStoragePermission(Context context) {
        if (AndroidVersion.isAndroid13() && AndroidVersion.getTargetSdkVersionCode(context) >= 33) {
            return PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_IMAGES") || this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
        }
        if (AndroidVersion.isAndroid11() && AndroidVersion.getTargetSdkVersionCode(context) >= 30) {
            return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE") || this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE");
        }
        return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
    }
}

