/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV14;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=23)
class PermissionDelegateImplV23
extends PermissionDelegateImplV14 {
    PermissionDelegateImplV23() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission) {
        if (PermissionUtils.isSpecialPermission(permission)) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.SYSTEM_ALERT_WINDOW")) {
                return PermissionDelegateImplV23.isGrantedWindowPermission(context);
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.WRITE_SETTINGS")) {
                return PermissionDelegateImplV23.isGrantedSettingPermission(context);
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_NOTIFICATION_POLICY")) {
                return PermissionDelegateImplV23.isGrantedNotDisturbPermission(context);
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
                return PermissionDelegateImplV23.isGrantedIgnoreBatteryPermission(context);
            }
            if (!AndroidVersion.isAndroid11() && PermissionUtils.equalsPermission(permission, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE") && PermissionUtils.checkSelfPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
            }
            return super.isGrantedPermission(context, permission);
        }
        if (!AndroidVersion.isAndroid13()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.POST_NOTIFICATIONS")) {
                return super.isGrantedPermission(context, permission);
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.NEARBY_WIFI_DEVICES")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.BODY_SENSORS_BACKGROUND")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.BODY_SENSORS");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.equalsPermission(permission, "android.permission.READ_MEDIA_AUDIO")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid12()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.BLUETOOTH_SCAN")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission, "android.permission.BLUETOOTH_ADVERTISE")) {
                return true;
            }
        }
        if (!AndroidVersion.isAndroid10()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACTIVITY_RECOGNITION")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.BODY_SENSORS");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_MEDIA_LOCATION")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid9() && PermissionUtils.equalsPermission(permission, "android.permission.ACCEPT_HANDOVER")) {
            return true;
        }
        if (!AndroidVersion.isAndroid8()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.ANSWER_PHONE_CALLS")) {
                return true;
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.READ_PHONE_NUMBERS")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_PHONE_STATE");
            }
        }
        return PermissionUtils.checkSelfPermission(context, permission);
    }

    @Override
    public boolean isPermissionPermanentDenied(Activity activity, String permission) {
        if (PermissionUtils.isSpecialPermission(permission)) {
            return false;
        }
        if (!AndroidVersion.isAndroid13()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.POST_NOTIFICATIONS")) {
                return super.isPermissionPermanentDenied(activity, permission);
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.NEARBY_WIFI_DEVICES")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.BODY_SENSORS_BACKGROUND")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.BODY_SENSORS") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.BODY_SENSORS");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.equalsPermission(permission, "android.permission.READ_MEDIA_AUDIO")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid12()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.BLUETOOTH_SCAN")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission, "android.permission.BLUETOOTH_ADVERTISE")) {
                return false;
            }
        }
        if (!AndroidVersion.isAndroid10()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACTIVITY_RECOGNITION")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.BODY_SENSORS") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.BODY_SENSORS");
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_MEDIA_LOCATION")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid9() && PermissionUtils.equalsPermission(permission, "android.permission.ACCEPT_HANDOVER")) {
            return false;
        }
        if (!AndroidVersion.isAndroid8()) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.ANSWER_PHONE_CALLS")) {
                return false;
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.READ_PHONE_NUMBERS")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_PHONE_STATE") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_PHONE_STATE");
            }
        }
        return !PermissionUtils.checkSelfPermission((Context)activity, permission) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission);
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission) {
        if (PermissionUtils.equalsPermission(permission, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return PermissionDelegateImplV23.getWindowPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.WRITE_SETTINGS")) {
            return PermissionDelegateImplV23.getSettingPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.ACCESS_NOTIFICATION_POLICY")) {
            return PermissionDelegateImplV23.getNotDisturbPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission, "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS")) {
            return PermissionDelegateImplV23.getIgnoreBatteryPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission);
    }

    private static boolean isGrantedWindowPermission(Context context) {
        return Settings.canDrawOverlays((Context)context);
    }

    private static Intent getWindowPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedSettingPermission(Context context) {
        if (AndroidVersion.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    private static Intent getSettingPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedNotDisturbPermission(Context context) {
        return ((NotificationManager)context.getSystemService(NotificationManager.class)).isNotificationPolicyAccessGranted();
    }

    private static Intent getNotDisturbPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid10()) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_DETAIL_SETTINGS");
            intent.setData(PermissionUtils.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean isGrantedIgnoreBatteryPermission(Context context) {
        return ((PowerManager)context.getSystemService(PowerManager.class)).isIgnoringBatteryOptimizations(context.getPackageName());
    }

    private static Intent getIgnoreBatteryPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.IGNORE_BATTERY_OPTIMIZATION_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionUtils.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

