/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Build;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionChecker {
    PermissionChecker() {
    }

    static boolean checkActivityStatus(Activity activity, boolean checkMode) {
        if (activity == null) {
            if (checkMode) {
                throw new IllegalArgumentException("The instance of the context must be an activity object");
            }
            return false;
        }
        if (activity.isFinishing()) {
            if (checkMode) {
                throw new IllegalStateException("The activity has been finishing, please manually determine the status of the activity");
            }
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            if (checkMode) {
                throw new IllegalStateException("The activity has been destroyed, please manually determine the status of the activity");
            }
            return false;
        }
        return true;
    }

    static boolean checkPermissionArgument(List<String> requestPermissions, boolean checkMode) {
        if (requestPermissions == null || requestPermissions.isEmpty()) {
            if (checkMode) {
                throw new IllegalArgumentException("The requested permission cannot be empty");
            }
            return false;
        }
        if (Build.VERSION.SDK_INT > 32) {
            return true;
        }
        if (checkMode) {
            ArrayList<String> allPermissions = new ArrayList<String>();
            Field[] fields = Permission.class.getDeclaredFields();
            if (fields.length == 0) {
                return true;
            }
            for (Field field : fields) {
                if (!String.class.equals(field.getType())) continue;
                try {
                    allPermissions.add((String)field.get(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            for (String permission2 : requestPermissions) {
                if (PermissionUtils.containsPermission(allPermissions, permission2)) continue;
                throw new IllegalArgumentException("The " + permission2 + " is not a dangerous permission or special permission, please do not apply dynamically");
            }
        }
        return true;
    }

    static void checkMediaLocationPermission(Context context, List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE") || PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) continue;
            throw new IllegalArgumentException("Because it includes access media location permissions, do not apply for permissions unrelated to access media location");
        }
        if (AndroidVersion.getTargetSdkVersionCode(context) >= 33) {
            if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("You must add android.permission.READ_MEDIA_IMAGES or android.permission.MANAGE_EXTERNAL_STORAGE rights to apply for android.permission.ACCESS_MEDIA_LOCATION rights");
            }
        } else if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("You must add android.permission.READ_EXTERNAL_STORAGE or android.permission.MANAGE_EXTERNAL_STORAGE rights to apply for android.permission.ACCESS_MEDIA_LOCATION rights");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkStoragePermission(Context context, List<String> requestPermissions) {
        if (!(PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            return;
        }
        if (AndroidVersion.getTargetSdkVersionCode(context) >= 33 && (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            throw new IllegalArgumentException("When targetSdkVersion >= 33 should use android.permission.READ_MEDIA_IMAGES, android.permission.READ_MEDIA_VIDEO, android.permission.READ_MEDIA_AUDIO instead of android.permission.READ_EXTERNAL_STORAGE, android.permission.WRITE_EXTERNAL_STORAGE");
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        boolean scopedStorage = PermissionUtils.isScopedStorage(context);
        XmlResourceParser parser = PermissionUtils.parseAndroidManifest(context);
        if (parser == null) {
            return;
        }
        try {
            do {
                if (parser.getEventType() != 2 || !"application".equals(parser.getName())) continue;
                int targetSdkVersion = AndroidVersion.getTargetSdkVersionCode(context);
                boolean requestLegacyExternalStorage = parser.getAttributeBooleanValue(PermissionUtils.getAndroidNamespace(), "requestLegacyExternalStorage", false);
                if (!(targetSdkVersion < 29 || requestLegacyExternalStorage || !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && scopedStorage)) {
                    throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
                }
                if (targetSdkVersion >= 30 && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && !scopedStorage) {
                    throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use android.permission.MANAGE_EXTERNAL_STORAGE to apply for permission");
                }
                break;
            } while (parser.next() != 1);
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        finally {
            parser.close();
        }
    }

    static void checkBodySensorsPermission(List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS")) {
            throw new IllegalArgumentException("Applying for background sensor permissions must contain android.permission.BODY_SENSORS");
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                throw new IllegalArgumentException("Applying for permissions android.permission.BODY_SENSORS_BACKGROUND and android.permission.ACCESS_BACKGROUND_LOCATION at the same time is not supported");
            }
            if (!PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_MEDIA_LOCATION")) continue;
            throw new IllegalArgumentException("Applying for permissions android.permission.BODY_SENSORS_BACKGROUND and android.permission.ACCESS_MEDIA_LOCATION at the same time is not supported");
        }
    }

    static void checkLocationPermission(Context context, List<String> requestPermissions) {
        if (AndroidVersion.getTargetSdkVersionCode(context) >= 31 && PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_COARSE_LOCATION")) {
            throw new IllegalArgumentException("If your app targets Android 12 or higher and requests the ACCESS_FINE_LOCATION runtime permission, you must also request the ACCESS_COARSE_LOCATION permission. You must include both permissions in a single runtime request.");
        }
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalArgumentException("Applying for background positioning permissions must include android.permission.ACCESS_FINE_LOCATION");
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_FINE_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_COARSE_LOCATION") || PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) continue;
            throw new IllegalArgumentException("Because it includes background location permissions, do not apply for permissions unrelated to location");
        }
    }

    static void checkTargetSdkVersion(Context context, List<String> requestPermissions) {
        int targetSdkMinVersion = PermissionUtils.containsPermission(requestPermissions, "android.permission.POST_NOTIFICATIONS") || PermissionUtils.containsPermission(requestPermissions, "android.permission.NEARBY_WIFI_DEVICES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO") ? 33 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_SCAN") || PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_ADVERTISE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.SCHEDULE_EXACT_ALARM") ? 31 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") ? 30 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_BACKGROUND_LOCATION") || PermissionUtils.containsPermission(requestPermissions, "android.permission.ACTIVITY_RECOGNITION") || PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION") ? 29 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCEPT_HANDOVER") ? 28 : (PermissionUtils.containsPermission(requestPermissions, "android.permission.REQUEST_INSTALL_PACKAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.ANSWER_PHONE_CALLS") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_PHONE_NUMBERS") ? 26 : 23)))));
        if (AndroidVersion.getTargetSdkVersionCode(context) < targetSdkMinVersion) {
            throw new RuntimeException("The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more, if you do not want to upgrade targetSdkVersion, please apply with the old permissions");
        }
    }

    static void checkManifestPermissions(Context context, List<String> requestPermissions) {
        HashMap<String, Integer> manifestPermissions = PermissionUtils.getManifestPermissions(context);
        if (manifestPermissions.isEmpty()) {
            throw new IllegalStateException("No permissions are registered in the AndroidManifest.xml file");
        }
        int minSdkVersion = Build.VERSION.SDK_INT >= 24 ? context.getApplicationInfo().minSdkVersion : 23;
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE") || PermissionUtils.equalsPermission(permission2, "android.permission.BIND_VPN_SERVICE")) continue;
            if (PermissionUtils.equalsPermission(permission2, "android.permission.BODY_SENSORS_BACKGROUND")) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BODY_SENSORS", Integer.MAX_VALUE);
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                if (AndroidVersion.getTargetSdkVersionCode(context) >= 31) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.ACCESS_FINE_LOCATION", 30);
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.ACCESS_COARSE_LOCATION", Integer.MAX_VALUE);
                } else {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.ACCESS_FINE_LOCATION", Integer.MAX_VALUE);
                }
            }
            if (minSdkVersion < 33) {
                if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_AUDIO")) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.READ_EXTERNAL_STORAGE", 32);
                }
                if (PermissionUtils.equalsPermission(permission2, "android.permission.NEARBY_WIFI_DEVICES")) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.ACCESS_FINE_LOCATION", 32);
                }
            }
            if (minSdkVersion < 31) {
                if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BLUETOOTH_ADMIN", 30);
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.ACCESS_FINE_LOCATION", 30);
                }
                if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT")) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BLUETOOTH", 30);
                }
                if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BLUETOOTH_ADMIN", 30);
                }
            }
            if (minSdkVersion < 30 && PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.READ_EXTERNAL_STORAGE", 29);
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE", 29);
            }
            if (minSdkVersion < 29 && PermissionUtils.equalsPermission(permission2, "android.permission.ACTIVITY_RECOGNITION")) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BODY_SENSORS", 28);
            }
            if (minSdkVersion < 26 && PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.READ_PHONE_STATE", 25);
            }
            PermissionChecker.checkManifestPermission(manifestPermissions, permission2, Integer.MAX_VALUE);
        }
    }

    static void checkManifestPermission(HashMap<String, Integer> manifestPermissions, String checkPermission, int maxSdkVersion) {
        if (!manifestPermissions.containsKey(checkPermission)) {
            throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" />");
        }
        Integer manifestMaxSdkVersion = manifestPermissions.get(checkPermission);
        if (manifestMaxSdkVersion == null) {
            return;
        }
        if (manifestMaxSdkVersion < maxSdkVersion) {
            throw new IllegalArgumentException("The AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" /> does not meet the requirements, " + (maxSdkVersion != Integer.MAX_VALUE ? "the minimum requirement for maxSdkVersion is " + maxSdkVersion : "please delete the android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" attribute"));
        }
    }

    static void optimizeDeprecatedPermission(List<String> requestPermissions) {
        if (!AndroidVersion.isAndroid13()) {
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.POST_NOTIFICATIONS") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.NOTIFICATION_SERVICE")) {
                requestPermissions.add("android.permission.NOTIFICATION_SERVICE");
            }
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.NEARBY_WIFI_DEVICES") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
                requestPermissions.add("android.permission.ACCESS_FINE_LOCATION");
            }
            if ((PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO")) && !PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid12() && PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_SCAN") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            requestPermissions.add("android.permission.ACCESS_FINE_LOCATION");
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("If you have applied for MANAGE_EXTERNAL_STORAGE permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions");
            }
            if (!AndroidVersion.isAndroid11()) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
                requestPermissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid10() && PermissionUtils.containsPermission(requestPermissions, "android.permission.ACTIVITY_RECOGNITION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS")) {
            requestPermissions.add("android.permission.BODY_SENSORS");
        }
        if (!AndroidVersion.isAndroid8() && PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_PHONE_NUMBERS") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_PHONE_STATE")) {
            requestPermissions.add("android.permission.READ_PHONE_STATE");
        }
    }
}

