/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.AlarmManager;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV30;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=31)
class PermissionDelegateImplV31
extends PermissionDelegateImplV30 {
    PermissionDelegateImplV31() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if ("android.permission.SCHEDULE_EXACT_ALARM".equals(permission2)) {
            return PermissionDelegateImplV31.isGrantedAlarmPermission(context);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission2) {
        if ("android.permission.SCHEDULE_EXACT_ALARM".equals(permission2)) {
            return PermissionDelegateImplV31.getAlarmPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    static boolean isGrantedAlarmPermission(Context context) {
        if (AndroidVersion.isAndroid12()) {
            return ((AlarmManager)context.getSystemService(AlarmManager.class)).canScheduleExactAlarms();
        }
        return true;
    }

    static Intent getAlarmPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

