/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV29;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=30)
class PermissionDelegateImplV30
extends PermissionDelegateImplV29 {
    PermissionDelegateImplV30() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
            return PermissionDelegateImplV30.isGrantedStoragePermission();
        }
        if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
            boolean hasStorage = this.isGrantedPermission(context, "android.permission.MANAGE_EXTERNAL_STORAGE") || PermissionDelegate.isGrantedDangerPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            return PermissionDelegate.isGrantedDangerPermission(context, "android.permission.ACCESS_MEDIA_LOCATION") && hasStorage;
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission2) {
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
            return PermissionDelegateImplV30.getStoragePermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    static boolean isGrantedStoragePermission() {
        return Environment.isExternalStorageManager();
    }

    static Intent getStoragePermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

