/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV23;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=26)
class PermissionDelegateImplV26
extends PermissionDelegateImplV23 {
    PermissionDelegateImplV26() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2)) {
            return PermissionDelegateImplV26.isGrantedInstallPermission(context);
        }
        if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
            return true;
        }
        if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
            return context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0;
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission2) {
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2)) {
            return PermissionDelegateImplV26.getInstallPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    static boolean isGrantedInstallPermission(Context context) {
        return context.getPackageManager().canRequestPackageInstalls();
    }

    static Intent getInstallPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

