/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV14;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=23)
class PermissionDelegateImplV23
extends PermissionDelegateImplV14 {
    PermissionDelegateImplV23() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if (PermissionDelegate.isSpecialPermission(permission2)) {
            if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
                return PermissionDelegateImplV23.isGrantedWindowPermission(context);
            }
            if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
                return PermissionDelegateImplV23.isGrantedSettingPermission(context);
            }
            if ("android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission2)) {
                return PermissionDelegateImplV23.isGrantedNotDisturbPermission(context);
            }
            if ("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS".equals(permission2)) {
                return PermissionDelegateImplV23.isGrantedIgnoreBatteryPermission(context);
            }
            return super.isGrantedPermission(context, permission2);
        }
        if (!AndroidVersion.isAndroid12()) {
            if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                return PermissionDelegate.isGrantedDangerPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
            }
            if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                return true;
            }
        }
        if (!AndroidVersion.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) {
                return PermissionDelegate.isGrantedDangerPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                return PermissionDelegate.isGrantedDangerPermission(context, "android.permission.BODY_SENSORS");
            }
            if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
                return PermissionDelegate.isGrantedDangerPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
            return true;
        }
        if (!AndroidVersion.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                return PermissionDelegate.isGrantedDangerPermission(context, "android.permission.READ_PHONE_STATE");
            }
        }
        return PermissionDelegate.isGrantedDangerPermission(context, permission2);
    }

    @Override
    public boolean isPermissionPermanentDenied(Context context, String permission2) {
        if (PermissionDelegate.isSpecialPermission(permission2)) {
            return false;
        }
        if (!AndroidVersion.isAndroid12()) {
            if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                return !PermissionDelegate.isGrantedDangerPermission(context, "android.permission.ACCESS_COARSE_LOCATION") && !PermissionDelegate.shouldShowRequestPermissionRationale(context, "android.permission.ACCESS_COARSE_LOCATION");
            }
            if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                return false;
            }
        }
        if (!AndroidVersion.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) {
                return !PermissionDelegate.isGrantedDangerPermission(context, "android.permission.ACCESS_FINE_LOCATION") && !PermissionDelegate.shouldShowRequestPermissionRationale(context, "android.permission.ACCESS_FINE_LOCATION");
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                return !PermissionDelegate.isGrantedDangerPermission(context, "android.permission.BODY_SENSORS") && !PermissionDelegate.shouldShowRequestPermissionRationale(context, "android.permission.BODY_SENSORS");
            }
            if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
                return !PermissionDelegate.isGrantedDangerPermission(context, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionDelegate.shouldShowRequestPermissionRationale(context, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }
        if (!AndroidVersion.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
            return false;
        }
        if (!AndroidVersion.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
                return false;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                return !PermissionDelegate.isGrantedDangerPermission(context, "android.permission.READ_PHONE_STATE") && !PermissionDelegate.shouldShowRequestPermissionRationale(context, "android.permission.READ_PHONE_STATE");
            }
        }
        return !PermissionDelegate.isGrantedDangerPermission(context, permission2) && !PermissionDelegate.shouldShowRequestPermissionRationale(context, permission2);
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission2) {
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
            return PermissionDelegateImplV23.getWindowPermissionIntent(context);
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
            return PermissionDelegateImplV23.getSettingPermissionIntent(context);
        }
        if ("android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission2)) {
            return PermissionDelegateImplV23.getNotDisturbPermissionIntent(context);
        }
        if ("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS".equals(permission2)) {
            return PermissionDelegateImplV23.getIgnoreBatteryPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    static boolean isGrantedWindowPermission(Context context) {
        return Settings.canDrawOverlays((Context)context);
    }

    static Intent getWindowPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static boolean isGrantedSettingPermission(Context context) {
        if (AndroidVersion.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    static Intent getSettingPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static boolean isGrantedNotDisturbPermission(Context context) {
        return ((NotificationManager)context.getSystemService(NotificationManager.class)).isNotificationPolicyAccessGranted();
    }

    static Intent getNotDisturbPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid10()) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_DETAIL_SETTINGS");
            intent.setData(PermissionDelegate.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static boolean isGrantedIgnoreBatteryPermission(Context context) {
        return ((PowerManager)context.getSystemService(PowerManager.class)).isIgnoringBatteryOptimizations(context.getPackageName());
    }

    static Intent getIgnoreBatteryPermissionIntent(Context context) {
        Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = new Intent("android.settings.IGNORE_BATTERY_OPTIMIZATION_SETTINGS");
        }
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

