/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationManagerCompat;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegate;
import com.hjq.permissions.PermissionUtils;
import java.util.Set;

@RequiresApi(api=14)
class PermissionDelegateImplV14
implements PermissionDelegate {
    PermissionDelegateImplV14() {
    }

    @Override
    public boolean isGrantedPermission(Context context, String permission2) {
        if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) {
            return PermissionDelegateImplV14.isGrantedNotifyPermission(context);
        }
        if ("android.permission.PACKAGE_USAGE_STATS".equals(permission2)) {
            return PermissionDelegateImplV14.isGrantedPackagePermission(context);
        }
        if ("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(permission2)) {
            return PermissionDelegateImplV14.isGrantedNotificationListenerPermission(context);
        }
        if ("android.permission.BIND_VPN_SERVICE".equals(permission2)) {
            return PermissionDelegateImplV14.isGrantedVpnPermission(context);
        }
        return true;
    }

    @Override
    public boolean isPermissionPermanentDenied(Context context, String permission2) {
        return false;
    }

    @Override
    public Intent getPermissionIntent(Context context, String permission2) {
        if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) {
            return PermissionDelegateImplV14.getNotifyPermissionIntent(context);
        }
        if ("android.permission.PACKAGE_USAGE_STATS".equals(permission2)) {
            return PermissionDelegateImplV14.getPackagePermissionIntent(context);
        }
        if ("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(permission2)) {
            return PermissionDelegateImplV14.getNotificationListenerIntent(context);
        }
        if ("android.permission.BIND_VPN_SERVICE".equals(permission2)) {
            return PermissionDelegateImplV14.getVpnPermissionIntent(context);
        }
        return PermissionDelegate.getApplicationDetailsIntent(context);
    }

    static boolean isGrantedNotifyPermission(Context context) {
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }

    static Intent getNotifyPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid8()) {
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static boolean isGrantedNotificationListenerPermission(Context context) {
        if (AndroidVersion.isAndroid4_3()) {
            Set packageNames = NotificationManagerCompat.getEnabledListenerPackages((Context)context);
            return packageNames.contains(context.getPackageName());
        }
        return true;
    }

    static Intent getNotificationListenerIntent(Context context) {
        Intent intent = AndroidVersion.isAndroid5_1() ? new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS") : new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static boolean isGrantedPackagePermission(Context context) {
        if (AndroidVersion.isAndroid5()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            int mode = AndroidVersion.isAndroid10() ? appOps.unsafeCheckOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName()) : appOps.checkOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName());
            return mode == 0;
        }
        return true;
    }

    static Intent getPackagePermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid5()) {
            intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            if (AndroidVersion.isAndroid10()) {
                intent.setData(PermissionDelegate.getPackageNameUri(context));
            }
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static boolean isGrantedVpnPermission(Context context) {
        return VpnService.prepare((Context)context) == null;
    }

    static Intent getVpnPermissionIntent(Context context) {
        Intent intent = VpnService.prepare((Context)context);
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegate.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

