/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public interface PermissionDelegate {
    public boolean isGrantedPermission(Context var1, String var2);

    public boolean isPermissionPermanentDenied(Context var1, String var2);

    public Intent getPermissionIntent(Context var1, String var2);

    public static boolean isSpecialPermission(String permission2) {
        return "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2) || "android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2) || "android.permission.SYSTEM_ALERT_WINDOW".equals(permission2) || "android.permission.WRITE_SETTINGS".equals(permission2) || "android.permission.NOTIFICATION_SERVICE".equals(permission2) || "android.permission.PACKAGE_USAGE_STATS".equals(permission2) || "android.permission.SCHEDULE_EXACT_ALARM".equals(permission2) || "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(permission2) || "android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission2) || "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS".equals(permission2) || "android.permission.BIND_VPN_SERVICE".equals(permission2);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedDangerPermission(Context context, String permission2) {
        return context.checkSelfPermission(permission2) == 0;
    }

    @RequiresApi(api=23)
    public static boolean shouldShowRequestPermissionRationale(Context context, String permission2) {
        Activity activity = PermissionUtils.findActivity(context);
        if (activity == null || AndroidVersion.isAndroid12()) {
            try {
                PackageManager packageManager = activity != null ? activity.getApplication().getPackageManager() : context.getPackageManager();
                Method method = PackageManager.class.getMethod("shouldShowRequestPermissionRationale", String.class);
                return (Boolean)method.invoke((Object)packageManager, permission2);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return activity.shouldShowRequestPermissionRationale(permission2);
    }

    public static Intent getApplicationDetailsIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(PermissionDelegate.getPackageNameUri(context));
        return intent;
    }

    public static Uri getPackageNameUri(Context context) {
        return Uri.parse((String)("package:" + context.getPackageName()));
    }
}

