/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.v4.app.NotificationManagerCompat;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class PermissionApi {
    PermissionApi() {
    }

    static boolean isGrantedStoragePermission(Context context) {
        if (AndroidVersion.isAndroid11()) {
            return Environment.isExternalStorageManager();
        }
        return PermissionApi.isGrantedPermissions(context, PermissionUtils.asArrayList(Permission.Group.STORAGE));
    }

    static boolean isGrantedInstallPermission(Context context) {
        if (AndroidVersion.isAndroid8()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean isGrantedWindowPermission(Context context) {
        if (AndroidVersion.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static boolean isGrantedSettingPermission(Context context) {
        if (AndroidVersion.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    static boolean isGrantedNotifyPermission(Context context) {
        return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
    }

    static boolean isGrantedNotificationListenerPermission(Context context) {
        if (AndroidVersion.isAndroid4_3()) {
            Set packageNames = NotificationManagerCompat.getEnabledListenerPackages((Context)context);
            return packageNames.contains(context.getPackageName());
        }
        return true;
    }

    static boolean isGrantedPackagePermission(Context context) {
        if (AndroidVersion.isAndroid5()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            int mode = AndroidVersion.isAndroid10() ? appOps.unsafeCheckOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName()) : appOps.checkOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName());
            return mode == 0;
        }
        return true;
    }

    static boolean isGrantedAlarmPermission(Context context) {
        if (AndroidVersion.isAndroid12()) {
            return ((AlarmManager)context.getSystemService(AlarmManager.class)).canScheduleExactAlarms();
        }
        return true;
    }

    static boolean isGrantedNotDisturbPermission(Context context) {
        if (AndroidVersion.isAndroid6()) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).isNotificationPolicyAccessGranted();
        }
        return true;
    }

    static boolean isGrantedIgnoreBatteryPermission(Context context) {
        if (AndroidVersion.isAndroid6()) {
            return ((PowerManager)context.getSystemService(PowerManager.class)).isIgnoringBatteryOptimizations(context.getPackageName());
        }
        return true;
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (!PermissionApi.isSpecialPermission(permission2)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecialPermission(String permission2) {
        return "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2) || "android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2) || "android.permission.SYSTEM_ALERT_WINDOW".equals(permission2) || "android.permission.WRITE_SETTINGS".equals(permission2) || "android.permission.NOTIFICATION_SERVICE".equals(permission2) || "android.permission.PACKAGE_USAGE_STATS".equals(permission2) || "android.permission.SCHEDULE_EXACT_ALARM".equals(permission2) || "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(permission2) || "android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission2) || "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS".equals(permission2);
    }

    static boolean isGrantedPermissions(Context context, List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    static List<String> getGrantedPermissions(Context context, List<String> permissions) {
        ArrayList<String> grantedPermission = new ArrayList<String>(permissions.size());
        for (String permission2 : permissions) {
            if (!PermissionApi.isGrantedPermission(context, permission2)) continue;
            grantedPermission.add(permission2);
        }
        return grantedPermission;
    }

    static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        ArrayList<String> deniedPermission = new ArrayList<String>(permissions.size());
        for (String permission2 : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission2)) continue;
            deniedPermission.add(permission2);
        }
        return deniedPermission;
    }

    static boolean isGrantedPermission(Context context, String permission2) {
        if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) {
            return PermissionApi.isGrantedNotifyPermission(context);
        }
        if ("android.permission.PACKAGE_USAGE_STATS".equals(permission2)) {
            return PermissionApi.isGrantedPackagePermission(context);
        }
        if ("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(permission2)) {
            return PermissionApi.isGrantedNotificationListenerPermission(context);
        }
        if (!AndroidVersion.isAndroid6()) {
            return true;
        }
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
            return PermissionApi.isGrantedStoragePermission(context);
        }
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2)) {
            return PermissionApi.isGrantedInstallPermission(context);
        }
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
            return PermissionApi.isGrantedWindowPermission(context);
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
            return PermissionApi.isGrantedSettingPermission(context);
        }
        if ("android.permission.SCHEDULE_EXACT_ALARM".equals(permission2)) {
            return PermissionApi.isGrantedAlarmPermission(context);
        }
        if ("android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission2)) {
            return PermissionApi.isGrantedNotDisturbPermission(context);
        }
        if ("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS".equals(permission2)) {
            return PermissionApi.isGrantedIgnoreBatteryPermission(context);
        }
        if (!AndroidVersion.isAndroid12()) {
            if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                return context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0;
            }
            if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                return true;
            }
        }
        if (!AndroidVersion.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) {
                return context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                return context.checkSelfPermission("android.permission.BODY_SENSORS") == 0;
            }
            if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
                return true;
            }
        }
        if (!AndroidVersion.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
            return true;
        }
        if (!AndroidVersion.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                return context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0;
            }
        }
        return context.checkSelfPermission(permission2) == 0;
    }

    static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission2 : permissions) {
            if (!PermissionApi.isPermissionPermanentDenied(activity, permission2)) continue;
            return true;
        }
        return false;
    }

    static boolean isPermissionPermanentDenied(Activity activity, String permission2) {
        if (PermissionApi.isSpecialPermission(permission2)) {
            return false;
        }
        if (!AndroidVersion.isAndroid6()) {
            return false;
        }
        if (!AndroidVersion.isAndroid12()) {
            if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                return !PermissionApi.isGrantedPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION") && !activity.shouldShowRequestPermissionRationale("android.permission.ACCESS_COARSE_LOCATION");
            }
            if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                return false;
            }
        }
        if (AndroidVersion.isAndroid10() && "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2) && !PermissionApi.isGrantedPermission((Context)activity, "android.permission.ACCESS_BACKGROUND_LOCATION") && !PermissionApi.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION")) {
            return !activity.shouldShowRequestPermissionRationale("android.permission.ACCESS_FINE_LOCATION");
        }
        if (!AndroidVersion.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) {
                return !PermissionApi.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !activity.shouldShowRequestPermissionRationale("android.permission.ACCESS_FINE_LOCATION");
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                return !PermissionApi.isGrantedPermission((Context)activity, "android.permission.BODY_SENSORS") && !activity.shouldShowRequestPermissionRationale("android.permission.BODY_SENSORS");
            }
            if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
                return false;
            }
        }
        if (!AndroidVersion.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
            return false;
        }
        if (!AndroidVersion.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
                return false;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                return !PermissionApi.isGrantedPermission((Context)activity, "android.permission.READ_PHONE_STATE") && !activity.shouldShowRequestPermissionRationale("android.permission.READ_PHONE_STATE");
            }
        }
        return !PermissionApi.isGrantedPermission((Context)activity, permission2) && !activity.shouldShowRequestPermissionRationale(permission2);
    }

    static List<String> getDeniedPermissions(List<String> permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions.get(i));
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermissions(List<String> permissions, int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions.get(i));
        }
        return grantedPermissions;
    }
}

