/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.IPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionChecker;
import com.hjq.permissions.PermissionPageFragment;
import com.hjq.permissions.PermissionPageIntent;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static IPermissionInterceptor sInterceptor;
    private static Boolean sCheckMode;
    private final Context mContext;
    private List<String> mPermissions;
    private IPermissionInterceptor mInterceptor;
    private Boolean mCheckMode;

    public static XXPermissions with(Context context) {
        return new XXPermissions(context);
    }

    public static XXPermissions with(Fragment fragment) {
        return XXPermissions.with((Context)fragment.getActivity());
    }

    public static XXPermissions with(android.support.v4.app.Fragment fragment) {
        return XXPermissions.with((Context)fragment.getActivity());
    }

    public static void setCheckMode(boolean checkMode) {
        sCheckMode = checkMode;
    }

    public static void setInterceptor(IPermissionInterceptor interceptor) {
        sInterceptor = interceptor;
    }

    public static IPermissionInterceptor getInterceptor() {
        if (sInterceptor == null) {
            sInterceptor = new IPermissionInterceptor(){};
        }
        return sInterceptor;
    }

    private XXPermissions(Context context) {
        this.mContext = context;
    }

    public XXPermissions permission(String ... permissions) {
        return this.permission(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions permission(String[] ... permissions) {
        return this.permission(PermissionUtils.asArrayLists(permissions));
    }

    public XXPermissions permission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this;
        }
        if (this.mPermissions == null) {
            this.mPermissions = new ArrayList<String>(permissions);
            return this;
        }
        for (String permission : permissions) {
            if (this.mPermissions.contains(permission)) continue;
            this.mPermissions.add(permission);
        }
        return this;
    }

    public XXPermissions interceptor(IPermissionInterceptor interceptor) {
        this.mInterceptor = interceptor;
        return this;
    }

    public XXPermissions unchecked() {
        this.mCheckMode = false;
        return this;
    }

    public void request(OnPermissionCallback callback) {
        Activity activity;
        if (this.mContext == null) {
            return;
        }
        if (this.mInterceptor == null) {
            this.mInterceptor = XXPermissions.getInterceptor();
        }
        ArrayList<String> permissions = new ArrayList<String>(this.mPermissions);
        if (this.mCheckMode == null) {
            if (sCheckMode == null) {
                sCheckMode = PermissionUtils.isDebugMode(this.mContext);
            }
            this.mCheckMode = sCheckMode;
        }
        if (!PermissionChecker.checkActivityStatus(activity = PermissionUtils.findActivity(this.mContext), this.mCheckMode)) {
            return;
        }
        if (!PermissionChecker.checkPermissionArgument(permissions, this.mCheckMode)) {
            return;
        }
        if (this.mCheckMode.booleanValue()) {
            PermissionChecker.checkStoragePermission(this.mContext, permissions);
            PermissionChecker.checkLocationPermission(this.mContext, permissions);
            PermissionChecker.checkTargetSdkVersion(this.mContext, permissions);
        }
        if (this.mCheckMode.booleanValue()) {
            PermissionChecker.checkManifestPermissions(this.mContext, permissions);
        }
        PermissionChecker.optimizeDeprecatedPermission(permissions);
        if (PermissionApi.isGrantedPermissions(this.mContext, permissions)) {
            if (callback != null) {
                this.mInterceptor.grantedPermissions(activity, permissions, permissions, true, callback);
            }
            return;
        }
        this.mInterceptor.requestPermissions(activity, callback, permissions);
    }

    public static boolean isGranted(Context context, String ... permissions) {
        return XXPermissions.isGranted(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGranted(Context context, String[] ... permissions) {
        return XXPermissions.isGranted(context, PermissionUtils.asArrayLists(permissions));
    }

    public static boolean isGranted(Context context, List<String> permissions) {
        return PermissionApi.isGrantedPermissions(context, permissions);
    }

    public static List<String> getDenied(Context context, String ... permissions) {
        return XXPermissions.getDenied(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<String> getDenied(Context context, String[] ... permissions) {
        return XXPermissions.getDenied(context, PermissionUtils.asArrayLists(permissions));
    }

    public static List<String> getDenied(Context context, List<String> permissions) {
        return PermissionApi.getDeniedPermissions(context, permissions);
    }

    public static boolean isSpecial(String permission2) {
        return PermissionApi.isSpecialPermission(permission2);
    }

    public static boolean isPermanentDenied(Activity activity, String ... permissions) {
        return XXPermissions.isPermanentDenied(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isPermanentDenied(Activity activity, String[] ... permissions) {
        return XXPermissions.isPermanentDenied(activity, PermissionUtils.asArrayLists(permissions));
    }

    public static boolean isPermanentDenied(Activity activity, List<String> permissions) {
        return PermissionApi.isPermissionPermanentDenied(activity, permissions);
    }

    public static void startPermissionActivity(Context context) {
        XXPermissions.startPermissionActivity(context, (List<String>)null);
    }

    public static void startPermissionActivity(Context context, String ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Context context, String[] ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(Context context, List<String> permissions) {
        Activity activity = PermissionUtils.findActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity(activity, permissions);
            return;
        }
        Intent intent = PermissionPageIntent.getSmartPermissionIntent(context, permissions);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public static void startPermissionActivity(Activity activity) {
        XXPermissions.startPermissionActivity(activity, (List<String>)null);
    }

    public static void startPermissionActivity(Activity activity, String ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Activity activity, String[] ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(Activity activity, List<String> permissions) {
        XXPermissions.startPermissionActivity(activity, permissions, 1025);
    }

    public static void startPermissionActivity(Activity activity, List<String> permissions, int requestCode) {
        activity.startActivityForResult(PermissionPageIntent.getSmartPermissionIntent((Context)activity, permissions), requestCode);
    }

    public static void startPermissionActivity(Activity activity, String permission2, OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(Activity activity, String[] permissions, OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(Activity activity, List<String> permissions, OnPermissionPageCallback callback) {
        PermissionPageFragment.beginRequest(activity, (ArrayList)permissions, callback);
    }

    public static void startPermissionActivity(Fragment fragment) {
        XXPermissions.startPermissionActivity(fragment, (List<String>)null);
    }

    public static void startPermissionActivity(Fragment fragment, String ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, String[] ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, List<String> permissions) {
        XXPermissions.startPermissionActivity(fragment, permissions, 1025);
    }

    public static void startPermissionActivity(Fragment fragment, List<String> permissions, int requestCode) {
        Activity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionPageIntent.getSmartPermissionIntent((Context)activity, permissions), requestCode);
    }

    public static void startPermissionActivity(Fragment fragment, String permission2, OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(Fragment fragment, String[] permissions, OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(Fragment fragment, List<String> permissions, OnPermissionPageCallback callback) {
        Activity activity = fragment.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            return;
        }
        PermissionPageFragment.beginRequest(activity, (ArrayList)permissions, callback);
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment) {
        XXPermissions.startPermissionActivity(fragment, (List<String>)null);
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, String ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, String[] ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, List<String> permissions) {
        XXPermissions.startPermissionActivity(fragment, permissions, 1025);
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, List<String> permissions, int requestCode) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionPageIntent.getSmartPermissionIntent((Context)activity, permissions), requestCode);
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, String permission2, OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, String[] permissions, OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(android.support.v4.app.Fragment fragment, List<String> permissions, OnPermissionPageCallback callback) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            return;
        }
        PermissionPageFragment.beginRequest((Activity)activity, (ArrayList)permissions, callback);
    }
}

