/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionApi;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    PermissionUtils() {
    }

    public static void postDelayed(Runnable r, long delayMillis) {
        HANDLER.postDelayed(r, delayMillis);
    }

    static String getAndroidNamespace() {
        return "http://schemas.android.com/apk/res/android";
    }

    static boolean isDebugMode(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashMap<String, Integer> getManifestPermissions(Context context) {
        HashMap<String, Integer> manifestPermissions = new HashMap<String, Integer>();
        XmlResourceParser parser = PermissionUtils.parseAndroidManifest(context);
        if (parser != null) {
            try {
                do {
                    if (parser.getEventType() != 2 || !"uses-permission".equals(parser.getName())) continue;
                    manifestPermissions.put(parser.getAttributeValue(PermissionUtils.getAndroidNamespace(), "name"), parser.getAttributeIntValue(PermissionUtils.getAndroidNamespace(), "maxSdkVersion", Integer.MAX_VALUE));
                } while (parser.next() != 1);
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
            finally {
                parser.close();
            }
        }
        if (manifestPermissions.isEmpty()) {
            try {
                String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
                if (requestedPermissions != null) {
                    for (String permission2 : requestedPermissions) {
                        manifestPermissions.put(permission2, Integer.MAX_VALUE);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return manifestPermissions;
    }

    static void optimizePermissionResults(Activity activity, String[] permissions, int[] grantResults) {
        for (int i = 0; i < permissions.length; ++i) {
            boolean recheck = false;
            String permission2 = permissions[i];
            if (PermissionApi.isSpecialPermission(permission2)) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid12() && ("android.permission.BLUETOOTH_SCAN".equals(permission2) || "android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2))) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2) || "android.permission.ACTIVITY_RECOGNITION".equals(permission2) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission2))) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
                recheck = true;
            }
            if (!AndroidVersion.isAndroid8() && ("android.permission.ANSWER_PHONE_CALLS".equals(permission2) || "android.permission.READ_PHONE_NUMBERS".equals(permission2))) {
                recheck = true;
            }
            if (!recheck) continue;
            grantResults[i] = PermissionApi.isGrantedPermission((Context)activity, permission2) ? 0 : -1;
        }
    }

    static <T> ArrayList<T> asArrayList(T ... array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        if (array == null || array.length == 0) {
            return list;
        }
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    static <T> ArrayList<T> asArrayLists(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (arrays == null || arrays.length == 0) {
            return list;
        }
        for (T[] ts : arrays) {
            list.addAll(PermissionUtils.asArrayList(ts));
        }
        return list;
    }

    static Activity findActivity(Context context) {
        do {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }

    @SuppressLint(value={"PrivateApi"})
    static int findApkPathCookie(Context context) {
        AssetManager assets = context.getAssets();
        String apkPath = context.getApplicationInfo().sourceDir;
        try {
            Method method = assets.getClass().getDeclaredMethod("addAssetPath", String.class);
            Integer cookie = (Integer)method.invoke((Object)assets, apkPath);
            if (cookie != null) {
                return cookie;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static XmlResourceParser parseAndroidManifest(Context context) {
        int cookie = PermissionUtils.findApkPathCookie(context);
        if (cookie == 0) {
            return null;
        }
        try {
            XmlResourceParser parser = context.getAssets().openXmlResourceParser(cookie, "AndroidManifest.xml");
            do {
                if (parser.getEventType() != 2 || !"manifest".equals(parser.getName()) || !TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)parser.getAttributeValue(null, "package"))) continue;
                return parser;
            } while (parser.next() != 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    static boolean isScopedStorage(Context context) {
        try {
            String metaKey = "ScopedStorage";
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return Boolean.parseBoolean(String.valueOf(metaData.get(metaKey)));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    static boolean isActivityReverse(Activity activity) {
        int activityRotation = AndroidVersion.isAndroid11() ? activity.getDisplay().getRotation() : activity.getWindowManager().getDefaultDisplay().getRotation();
        switch (activityRotation) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static boolean areActivityIntent(Context context, Intent intent) {
        return !context.getPackageManager().queryIntentActivities(intent, 65536).isEmpty();
    }
}

