/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionUtils;
import java.util.List;

final class PermissionPageIntent {
    PermissionPageIntent() {
    }

    static Intent getSmartPermissionIntent(Context context, List<String> permissions) {
        if (permissions == null || permissions.isEmpty() || !PermissionApi.containsSpecialPermission(permissions)) {
            return PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        if (AndroidVersion.isAndroid11() && permissions.size() == 3 && permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && permissions.contains("android.permission.READ_EXTERNAL_STORAGE") && permissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
            return PermissionPageIntent.getStoragePermissionIntent(context);
        }
        if (permissions.size() == 1) {
            String permission2 = permissions.get(0);
            if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
                return PermissionPageIntent.getStoragePermissionIntent(context);
            }
            if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2)) {
                return PermissionPageIntent.getInstallPermissionIntent(context);
            }
            if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
                return PermissionPageIntent.getWindowPermissionIntent(context);
            }
            if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
                return PermissionPageIntent.getSettingPermissionIntent(context);
            }
            if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) {
                return PermissionPageIntent.getNotifyPermissionIntent(context);
            }
            if ("android.permission.PACKAGE_USAGE_STATS".equals(permission2)) {
                return PermissionPageIntent.getPackagePermissionIntent(context);
            }
            if ("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE".equals(permission2)) {
                return PermissionPageIntent.getNotificationListenerIntent(context);
            }
            if ("android.permission.SCHEDULE_EXACT_ALARM".equals(permission2)) {
                return PermissionPageIntent.getAlarmPermissionIntent(context);
            }
            if ("android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission2)) {
                return PermissionPageIntent.getNotDisturbPermissionIntent(context);
            }
        }
        return PermissionPageIntent.getApplicationDetailsIntent(context);
    }

    static Intent getApplicationDetailsIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(PermissionPageIntent.getPackageNameUri(context));
        return intent;
    }

    static Intent getInstallPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid8()) {
            intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
            intent.setData(PermissionPageIntent.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getWindowPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid6()) {
            intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            intent.setData(PermissionPageIntent.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getNotifyPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid8()) {
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getNotificationListenerIntent(Context context) {
        Intent intent = AndroidVersion.isAndroid5_1() ? new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS") : new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getSettingPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid6()) {
            intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(PermissionPageIntent.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getStoragePermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid11()) {
            intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
            intent.setData(PermissionPageIntent.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getPackagePermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid5()) {
            intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            if (AndroidVersion.isAndroid10()) {
                intent.setData(PermissionPageIntent.getPackageNameUri(context));
            }
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getNotDisturbPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid6()) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getAlarmPermissionIntent(Context context) {
        Intent intent = null;
        if (AndroidVersion.isAndroid12()) {
            intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
            intent.setData(PermissionPageIntent.getPackageNameUri(context));
        }
        if (intent == null || !PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionPageIntent.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static Uri getPackageNameUri(Context context) {
        return Uri.parse((String)("package:" + context.getPackageName()));
    }
}

