/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionPageIntent;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class PermissionPageFragment
extends Fragment
implements Runnable {
    public static final int REQUEST_CODE = 1025;
    private static final String REQUEST_PERMISSIONS = "request_permissions";
    private OnPermissionPageCallback mCallBack;
    private boolean mRequestFlag;
    private boolean mStartActivityFlag;

    public static void beginRequest(Activity activity, ArrayList<String> permissions, OnPermissionPageCallback callback) {
        PermissionPageFragment fragment = new PermissionPageFragment();
        Bundle bundle = new Bundle();
        bundle.putStringArrayList(REQUEST_PERMISSIONS, permissions);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setCallBack(callback);
        fragment.attachActivity(activity);
    }

    public void attachActivity(Activity activity) {
        activity.getFragmentManager().beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachActivity(Activity activity) {
        activity.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequestFlag) {
            this.detachActivity(this.getActivity());
            return;
        }
        if (this.mStartActivityFlag) {
            return;
        }
        this.mStartActivityFlag = true;
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList permissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        this.startActivityForResult(PermissionPageIntent.getSmartPermissionIntent((Context)this.getActivity(), permissions), 1025);
    }

    public void setCallBack(OnPermissionPageCallback callback) {
        this.mCallBack = callback;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 1025) {
            return;
        }
        PermissionUtils.postDelayed(this, 300L);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        OnPermissionPageCallback callback = this.mCallBack;
        this.mCallBack = null;
        if (callback == null) {
            this.detachActivity(this.getActivity());
            return;
        }
        Bundle arguments = this.getArguments();
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        List<String> grantedPermissions = PermissionApi.getGrantedPermissions((Context)activity, allPermissions);
        if (grantedPermissions.size() == allPermissions.size()) {
            callback.onGranted();
        } else {
            callback.onDenied();
        }
    }
}

