/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.IPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionPageIntent;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class PermissionFragment
extends Fragment
implements Runnable {
    private static final String REQUEST_PERMISSIONS = "request_permissions";
    private static final String REQUEST_CODE = "request_code";
    private static final List<Integer> REQUEST_CODE_ARRAY = new ArrayList<Integer>();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;
    private boolean mRequestFlag;
    private OnPermissionCallback mCallBack;
    private IPermissionInterceptor mInterceptor;
    private int mScreenOrientation;

    public static void beginRequest(Activity activity, ArrayList<String> permissions, IPermissionInterceptor interceptor, OnPermissionCallback callback) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Bundle bundle = new Bundle();
        while (REQUEST_CODE_ARRAY.contains(requestCode = new Random().nextInt((int)Math.pow(2.0, 8.0)))) {
        }
        REQUEST_CODE_ARRAY.add(requestCode);
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(REQUEST_PERMISSIONS, permissions);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setCallBack(callback);
        fragment.setInterceptor(interceptor);
        fragment.attachActivity(activity);
    }

    public void attachActivity(Activity activity) {
        activity.getFragmentManager().beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachActivity(Activity activity) {
        activity.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void setCallBack(OnPermissionCallback callback) {
        this.mCallBack = callback;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void setInterceptor(IPermissionInterceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void onAttach(Context context) {
        super.onAttach(context);
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mScreenOrientation = activity.getRequestedOrientation();
        if (this.mScreenOrientation != -1) {
            return;
        }
        try {
            switch (activity.getResources().getConfiguration().orientation) {
                case 2: {
                    activity.setRequestedOrientation(PermissionUtils.isActivityReverse(activity) ? 8 : 0);
                    break;
                }
                default: {
                    activity.setRequestedOrientation(PermissionUtils.isActivityReverse(activity) ? 9 : 1);
                    break;
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void onDetach() {
        super.onDetach();
        Activity activity = this.getActivity();
        if (activity == null || this.mScreenOrientation != -1) {
            return;
        }
        activity.setRequestedOrientation(-1);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequestFlag) {
            this.detachActivity(this.getActivity());
            return;
        }
        if (this.mSpecialRequest) {
            return;
        }
        this.mSpecialRequest = true;
        this.requestSpecialPermission();
    }

    public void requestSpecialPermission() {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        boolean requestSpecialPermission = false;
        for (String permission2 : allPermissions) {
            if (!PermissionApi.isSpecialPermission(permission2) || PermissionApi.isGrantedPermission((Context)activity, permission2) || "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2) && !AndroidVersion.isAndroid11()) continue;
            this.startActivityForResult(PermissionPageIntent.getSmartPermissionIntent((Context)activity, PermissionUtils.asArrayList(permission2)), this.getArguments().getInt(REQUEST_CODE));
            requestSpecialPermission = true;
        }
        if (requestSpecialPermission) {
            return;
        }
        this.requestDangerousPermission();
    }

    public void requestDangerousPermission() {
        final Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null) {
            return;
        }
        final int requestCode = arguments.getInt(REQUEST_CODE);
        final ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        if (!AndroidVersion.isAndroid6()) {
            int[] grantResults = new int[allPermissions.size()];
            for (int i = 0; i < grantResults.length; ++i) {
                grantResults[i] = PermissionApi.isGrantedPermission((Context)activity, (String)allPermissions.get(i)) ? 0 : -1;
            }
            this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
            return;
        }
        ArrayList<String> locationPermission = null;
        if (AndroidVersion.isAndroid10() && allPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            locationPermission = new ArrayList<String>();
            if (allPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (allPermissions.contains("android.permission.ACCESS_FINE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_FINE_LOCATION");
            }
        }
        if (!AndroidVersion.isAndroid10() || locationPermission == null || locationPermission.isEmpty()) {
            this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
            return;
        }
        PermissionFragment.beginRequest(activity, locationPermission, new IPermissionInterceptor(){}, new OnPermissionCallback(){

            @Override
            public void onGranted(List<String> permissions, boolean all) {
                if (!all || !PermissionFragment.this.isAdded()) {
                    return;
                }
                PermissionFragment.beginRequest(activity, PermissionUtils.asArrayList("android.permission.ACCESS_BACKGROUND_LOCATION"), new IPermissionInterceptor(){}, new OnPermissionCallback(){

                    @Override
                    public void onGranted(List<String> permissions, boolean all) {
                        if (!all || !PermissionFragment.this.isAdded()) {
                            return;
                        }
                        int[] grantResults = new int[allPermissions.size()];
                        Arrays.fill(grantResults, 0);
                        PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
                    }

                    @Override
                    public void onDenied(List<String> permissions, boolean never) {
                        if (!PermissionFragment.this.isAdded()) {
                            return;
                        }
                        int[] grantResults = new int[allPermissions.size()];
                        for (int i = 0; i < allPermissions.size(); ++i) {
                            grantResults[i] = "android.permission.ACCESS_BACKGROUND_LOCATION".equals(allPermissions.get(i)) ? -1 : 0;
                        }
                        PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
                    }
                });
            }

            @Override
            public void onDenied(List<String> permissions, boolean never) {
                if (!PermissionFragment.this.isAdded()) {
                    return;
                }
                int[] grantResults = new int[allPermissions.size()];
                Arrays.fill(grantResults, -1);
                PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || permissions.length == 0 || grantResults == null || grantResults.length == 0) {
            return;
        }
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (activity == null || arguments == null || this.mInterceptor == null || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        OnPermissionCallback callback = this.mCallBack;
        this.mCallBack = null;
        IPermissionInterceptor interceptor = this.mInterceptor;
        this.mInterceptor = null;
        PermissionUtils.optimizePermissionResults(activity, permissions, grantResults);
        ArrayList<String> allPermissions = PermissionUtils.asArrayList(permissions);
        REQUEST_CODE_ARRAY.remove((Object)requestCode);
        this.detachActivity(activity);
        List<String> grantedPermissions = PermissionApi.getGrantedPermissions(allPermissions, grantResults);
        if (grantedPermissions.size() == allPermissions.size()) {
            interceptor.grantedPermissions(activity, allPermissions, grantedPermissions, true, callback);
            return;
        }
        List<String> deniedPermissions = PermissionApi.getDeniedPermissions(allPermissions, grantResults);
        interceptor.deniedPermissions(activity, allPermissions, deniedPermissions, PermissionApi.isPermissionPermanentDenied(activity, deniedPermissions), callback);
        if (!grantedPermissions.isEmpty()) {
            interceptor.grantedPermissions(activity, allPermissions, grantedPermissions, false, callback);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null || this.mDangerousRequest || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        this.mDangerousRequest = true;
        PermissionUtils.postDelayed(this, 300L);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        this.requestDangerousPermission();
    }
}

