/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.Settings;
import android.text.TextUtils;
import com.hjq.permissions.Permission;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionUtils {
    PermissionUtils() {
    }

    static boolean isAndroid12() {
        return Build.VERSION.SDK_INT >= 31;
    }

    static boolean isAndroid11() {
        return Build.VERSION.SDK_INT >= 30;
    }

    static boolean isAndroid10() {
        return Build.VERSION.SDK_INT >= 29;
    }

    static boolean isAndroid9() {
        return Build.VERSION.SDK_INT >= 28;
    }

    static boolean isAndroid8() {
        return Build.VERSION.SDK_INT >= 26;
    }

    static boolean isAndroid6() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static boolean isAndroid5() {
        return Build.VERSION.SDK_INT >= 21;
    }

    static String getAndroidNamespace() {
        return "http://schemas.android.com/apk/res/android";
    }

    static boolean isDebugMode(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashMap<String, Integer> getManifestPermissions(Context context) {
        HashMap<String, Integer> manifestPermissions = new HashMap<String, Integer>();
        XmlResourceParser parser = PermissionUtils.parseAndroidManifest(context);
        if (parser != null) {
            try {
                do {
                    if (parser.getEventType() != 2 || !"uses-permission".equals(parser.getName())) continue;
                    manifestPermissions.put(parser.getAttributeValue(PermissionUtils.getAndroidNamespace(), "name"), parser.getAttributeIntValue(PermissionUtils.getAndroidNamespace(), "maxSdkVersion", Integer.MAX_VALUE));
                } while (parser.next() != 1);
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
            finally {
                parser.close();
            }
        }
        if (manifestPermissions.isEmpty()) {
            try {
                String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
                if (requestedPermissions != null) {
                    for (String permission2 : requestedPermissions) {
                        manifestPermissions.put(permission2, Integer.MAX_VALUE);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return manifestPermissions;
    }

    static boolean isGrantedStoragePermission(Context context) {
        if (PermissionUtils.isAndroid11()) {
            return Environment.isExternalStorageManager();
        }
        return PermissionUtils.isGrantedPermissions(context, PermissionUtils.asArrayList(Permission.Group.STORAGE));
    }

    static boolean isGrantedInstallPermission(Context context) {
        if (PermissionUtils.isAndroid8()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean isGrantedWindowPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static boolean isGrantedSettingPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    static boolean isGrantedNotifyPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    static boolean isGrantedPackagePermission(Context context) {
        if (PermissionUtils.isAndroid5()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            int mode = PermissionUtils.isAndroid10() ? appOps.unsafeCheckOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName()) : appOps.checkOpNoThrow("android:get_usage_stats", context.getApplicationInfo().uid, context.getPackageName());
            return mode == 0;
        }
        return true;
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (!PermissionUtils.isSpecialPermission(permission2)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecialPermission(String permission2) {
        return "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2) || "android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2) || "android.permission.SYSTEM_ALERT_WINDOW".equals(permission2) || "android.permission.WRITE_SETTINGS".equals(permission2) || "android.permission.NOTIFICATION_SERVICE".equals(permission2) || "android.permission.PACKAGE_USAGE_STATS".equals(permission2);
    }

    static boolean isGrantedPermissions(Context context, List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission2 : permissions) {
            if (PermissionUtils.isGrantedPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        ArrayList<String> deniedPermission = new ArrayList<String>(permissions.size());
        if (!PermissionUtils.isAndroid6()) {
            return deniedPermission;
        }
        for (String permission2 : permissions) {
            if (PermissionUtils.isGrantedPermission(context, permission2)) continue;
            deniedPermission.add(permission2);
        }
        return deniedPermission;
    }

    static boolean isGrantedPermission(Context context, String permission2) {
        if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) {
            return PermissionUtils.isGrantedNotifyPermission(context);
        }
        if ("android.permission.PACKAGE_USAGE_STATS".equals(permission2)) {
            return PermissionUtils.isGrantedPackagePermission(context);
        }
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
            return PermissionUtils.isGrantedStoragePermission(context);
        }
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2)) {
            return PermissionUtils.isGrantedInstallPermission(context);
        }
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
            return PermissionUtils.isGrantedWindowPermission(context);
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
            return PermissionUtils.isGrantedSettingPermission(context);
        }
        if (!PermissionUtils.isAndroid12()) {
            if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                return context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0;
            }
            if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                return true;
            }
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) {
                return context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                return context.checkSelfPermission("android.permission.BODY_SENSORS") == 0;
            }
            if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
                return true;
            }
        }
        if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
            return true;
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                return context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0;
            }
        }
        return context.checkSelfPermission(permission2) == 0;
    }

    static void optimizePermissionResults(Activity activity, String[] permissions, int[] grantResults) {
        for (int i = 0; i < permissions.length; ++i) {
            boolean recheck = false;
            String permission2 = permissions[i];
            if (PermissionUtils.isSpecialPermission(permission2)) {
                recheck = true;
            }
            if (!PermissionUtils.isAndroid12() && ("android.permission.BLUETOOTH_SCAN".equals(permission2) || "android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2))) {
                recheck = true;
            }
            if (!PermissionUtils.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2) || "android.permission.ACTIVITY_RECOGNITION".equals(permission2) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission2))) {
                recheck = true;
            }
            if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
                recheck = true;
            }
            if (!PermissionUtils.isAndroid8() && ("android.permission.ANSWER_PHONE_CALLS".equals(permission2) || "android.permission.READ_PHONE_NUMBERS".equals(permission2))) {
                recheck = true;
            }
            if (!recheck) continue;
            grantResults[i] = PermissionUtils.isGrantedPermission((Context)activity, permission2) ? 0 : -1;
        }
    }

    static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission2 : permissions) {
            if (!PermissionUtils.isPermissionPermanentDenied(activity, permission2)) continue;
            return true;
        }
        return false;
    }

    static boolean isPermissionPermanentDenied(Activity activity, String permission2) {
        if (!PermissionUtils.isAndroid6()) {
            return false;
        }
        if (PermissionUtils.isSpecialPermission(permission2)) {
            return false;
        }
        if (!PermissionUtils.isAndroid12()) {
            if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                return !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION") && !activity.shouldShowRequestPermissionRationale("android.permission.ACCESS_COARSE_LOCATION");
            }
            if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                return false;
            }
        }
        if (PermissionUtils.isAndroid10() && "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2) && !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_BACKGROUND_LOCATION") && !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION")) {
            return !activity.shouldShowRequestPermissionRationale("android.permission.ACCESS_FINE_LOCATION");
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) {
                return !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !activity.shouldShowRequestPermissionRationale("android.permission.ACCESS_FINE_LOCATION");
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                return !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.BODY_SENSORS") && !activity.shouldShowRequestPermissionRationale("android.permission.BODY_SENSORS");
            }
            if ("android.permission.ACCESS_MEDIA_LOCATION".equals(permission2)) {
                return false;
            }
        }
        if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
            return false;
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission2)) {
                return false;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                return !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.READ_PHONE_STATE") && !activity.shouldShowRequestPermissionRationale("android.permission.READ_PHONE_STATE");
            }
        }
        return !PermissionUtils.isGrantedPermission((Context)activity, permission2) && !activity.shouldShowRequestPermissionRationale(permission2);
    }

    static List<String> getDeniedPermissions(List<String> permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions.get(i));
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermissions(List<String> permissions, int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions.get(i));
        }
        return grantedPermissions;
    }

    static <T> ArrayList<T> asArrayList(T ... array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        if (array == null || array.length == 0) {
            return list;
        }
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    static <T> ArrayList<T> asArrayLists(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (arrays == null || arrays.length == 0) {
            return list;
        }
        for (T[] ts : arrays) {
            list.addAll(PermissionUtils.asArrayList(ts));
        }
        return list;
    }

    static Activity findActivity(Context context) {
        do {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }

    @SuppressLint(value={"PrivateApi"})
    static int findApkPathCookie(Context context) {
        AssetManager assets = context.getAssets();
        String apkPath = context.getApplicationInfo().sourceDir;
        try {
            Method method = assets.getClass().getDeclaredMethod("addAssetPath", String.class);
            Integer cookie = (Integer)method.invoke((Object)assets, apkPath);
            if (cookie != null) {
                return cookie;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static XmlResourceParser parseAndroidManifest(Context context) {
        int cookie = PermissionUtils.findApkPathCookie(context);
        if (cookie == 0) {
            return null;
        }
        try {
            XmlResourceParser parser = context.getAssets().openXmlResourceParser(cookie, "AndroidManifest.xml");
            do {
                if (parser.getEventType() != 2 || !"manifest".equals(parser.getName()) || !TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)parser.getAttributeValue(null, "package"))) continue;
                return parser;
            } while (parser.next() != 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    static boolean isScopedStorage(Context context) {
        try {
            String metaKey = "ScopedStorage";
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && metaData.containsKey(metaKey)) {
                return Boolean.parseBoolean(String.valueOf(metaData.get(metaKey)));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    static boolean isActivityReverse(Activity activity) {
        int activityRotation = Build.VERSION.SDK_INT >= 30 ? activity.getDisplay().getRotation() : activity.getWindowManager().getDefaultDisplay().getRotation();
        switch (activityRotation) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }
}

