/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.hjq.permissions.PermissionUtils;
import java.util.List;

final class PermissionSettingPage {
    PermissionSettingPage() {
    }

    static Intent getSmartPermissionIntent(Context context, List<String> permissions) {
        if (permissions == null || permissions.isEmpty() || !PermissionUtils.containsSpecialPermission(permissions)) {
            return PermissionSettingPage.getApplicationDetailsIntent(context);
        }
        if (PermissionUtils.isAndroid11() && permissions.size() == 3 && permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && permissions.contains("android.permission.READ_EXTERNAL_STORAGE") && permissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
            return PermissionSettingPage.getStoragePermissionIntent(context);
        }
        if (permissions.size() == 1) {
            String permission2 = permissions.get(0);
            if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
                return PermissionSettingPage.getStoragePermissionIntent(context);
            }
            if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission2)) {
                return PermissionSettingPage.getInstallPermissionIntent(context);
            }
            if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission2)) {
                return PermissionSettingPage.getWindowPermissionIntent(context);
            }
            if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) {
                return PermissionSettingPage.getNotifyPermissionIntent(context);
            }
            if ("android.permission.WRITE_SETTINGS".equals(permission2)) {
                return PermissionSettingPage.getSettingPermissionIntent(context);
            }
        }
        return PermissionSettingPage.getApplicationDetailsIntent(context);
    }

    static Intent getApplicationDetailsIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(PermissionSettingPage.getPackageNameUri(context));
        return intent;
    }

    static Intent getInstallPermissionIntent(Context context) {
        Intent intent = null;
        if (PermissionUtils.isAndroid8()) {
            intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
            intent.setData(PermissionSettingPage.getPackageNameUri(context));
        }
        if (intent == null || !PermissionSettingPage.areActivityIntent(context, intent)) {
            intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getWindowPermissionIntent(Context context) {
        Intent intent = null;
        if (PermissionUtils.isAndroid6()) {
            intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            intent.setData(PermissionSettingPage.getPackageNameUri(context));
        }
        if (intent == null || !PermissionSettingPage.areActivityIntent(context, intent)) {
            intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getNotifyPermissionIntent(Context context) {
        Intent intent = null;
        if (PermissionUtils.isAndroid8()) {
            intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        }
        if (intent == null || !PermissionSettingPage.areActivityIntent(context, intent)) {
            intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getSettingPermissionIntent(Context context) {
        Intent intent = null;
        if (PermissionUtils.isAndroid6()) {
            intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(PermissionSettingPage.getPackageNameUri(context));
        }
        if (intent == null || !PermissionSettingPage.areActivityIntent(context, intent)) {
            intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    static Intent getStoragePermissionIntent(Context context) {
        Intent intent = null;
        if (PermissionUtils.isAndroid11()) {
            intent = new Intent("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
            intent.setData(PermissionSettingPage.getPackageNameUri(context));
        }
        if (intent == null || !PermissionSettingPage.areActivityIntent(context, intent)) {
            intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    private static boolean areActivityIntent(Context context, Intent intent) {
        return !context.getPackageManager().queryIntentActivities(intent, 65536).isEmpty();
    }

    private static Uri getPackageNameUri(Context context) {
        return Uri.parse((String)("package:" + context.getPackageName()));
    }
}

