/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Build;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionChecker {
    PermissionChecker() {
    }

    static boolean checkActivityStatus(Activity activity, boolean checkMode) {
        if (activity == null) {
            if (checkMode) {
                throw new IllegalArgumentException("The instance of the context must be an activity object");
            }
            return false;
        }
        if (activity.isFinishing()) {
            if (checkMode) {
                throw new IllegalStateException("The activity has been finishing, please manually determine the status of the activity");
            }
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            if (checkMode) {
                throw new IllegalStateException("The activity has been destroyed, please manually determine the status of the activity");
            }
            return false;
        }
        return true;
    }

    static boolean checkPermissionArgument(List<String> requestPermissions, boolean checkMode) {
        if (requestPermissions == null || requestPermissions.isEmpty()) {
            if (checkMode) {
                throw new IllegalArgumentException("The requested permission cannot be empty");
            }
            return false;
        }
        if (checkMode) {
            ArrayList<String> allPermissions = new ArrayList<String>();
            Field[] fields = Permission.class.getDeclaredFields();
            if (fields.length == 0) {
                return true;
            }
            for (Field field : fields) {
                if (!String.class.equals(field.getType())) continue;
                try {
                    allPermissions.add((String)field.get(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            for (String permission2 : requestPermissions) {
                if (allPermissions.contains(permission2)) continue;
                throw new IllegalArgumentException("The " + permission2 + " is not a dangerous permission or special permission, please do not apply dynamically");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkStoragePermission(Context context, List<String> requestPermissions) {
        if (!(requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE"))) {
            return;
        }
        boolean scopedStorage = PermissionUtils.isScopedStorage(context);
        XmlResourceParser parser = PermissionUtils.parseAndroidManifest(context);
        if (parser == null) {
            return;
        }
        try {
            do {
                if (parser.getEventType() != 2 || !"application".equals(parser.getName())) continue;
                int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
                boolean requestLegacyExternalStorage = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "requestLegacyExternalStorage", false);
                if (!(targetSdkVersion < 29 || requestLegacyExternalStorage || !requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && scopedStorage)) {
                    throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
                }
                if (targetSdkVersion >= 30 && !requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && !scopedStorage) {
                    throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use MANAGE_EXTERNAL_STORAGE to apply for permission");
                }
                break;
            } while (parser.next() != 1);
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        finally {
            parser.close();
        }
    }

    static void checkLocationPermission(Context context, List<String> requestPermissions) {
        if (context.getApplicationInfo().targetSdkVersion >= 31 && requestPermissions.contains("android.permission.ACCESS_FINE_LOCATION") && !requestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
            throw new IllegalArgumentException("If your app targets Android 12 or higher and requests the ACCESS_FINE_LOCATION runtime permission, you must also request the ACCESS_COARSE_LOCATION permission. You must include both permissions in a single runtime request.");
        }
        if (!requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            return;
        }
        if (requestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION") && !requestPermissions.contains("android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalArgumentException("The application for background location permissions must include precise location permissions");
        }
        for (String permission2 : requestPermissions) {
            if ("android.permission.ACCESS_FINE_LOCATION".equals(permission2) || "android.permission.ACCESS_COARSE_LOCATION".equals(permission2) || "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) continue;
            throw new IllegalArgumentException("Because it includes background location permissions, do not apply for permissions unrelated to location");
        }
    }

    static void checkTargetSdkVersion(Context context, List<String> requestPermissions) {
        int targetSdkMinVersion = requestPermissions.contains("android.permission.BLUETOOTH_SCAN") || requestPermissions.contains("android.permission.BLUETOOTH_CONNECT") || requestPermissions.contains("android.permission.BLUETOOTH_ADVERTISE") ? 31 : (requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") ? 30 : (requestPermissions.contains("android.permission.ACCEPT_HANDOVER") ? 28 : (requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION") || requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") || requestPermissions.contains("android.permission.ACCESS_MEDIA_LOCATION") ? 29 : (requestPermissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") || requestPermissions.contains("android.permission.ANSWER_PHONE_CALLS") || requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") ? 26 : 23))));
        if (context.getApplicationInfo().targetSdkVersion < targetSdkMinVersion) {
            throw new RuntimeException("The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more, if you do not want to upgrade targetSdkVersion, please apply with the old permissions");
        }
    }

    static void checkManifestPermissions(Context context, List<String> requestPermissions) {
        HashMap<String, Integer> manifestPermissions = PermissionUtils.getManifestPermissions(context);
        if (manifestPermissions.isEmpty()) {
            throw new IllegalStateException("No permissions are registered in the AndroidManifest.xml file");
        }
        int minSdkVersion = Build.VERSION.SDK_INT >= 24 ? context.getApplicationInfo().minSdkVersion : 23;
        for (String permission2 : requestPermissions) {
            if ("android.permission.NOTIFICATION_SERVICE".equals(permission2)) continue;
            int sdkVersion = 31;
            if (31 >= minSdkVersion) {
                if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BLUETOOTH_ADMIN", sdkVersion);
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.ACCESS_COARSE_LOCATION", sdkVersion);
                }
                if ("android.permission.BLUETOOTH_CONNECT".equals(permission2)) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BLUETOOTH", sdkVersion);
                }
                if ("android.permission.BLUETOOTH_ADVERTISE".equals(permission2)) {
                    PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BLUETOOTH_ADMIN", sdkVersion);
                }
            }
            sdkVersion = 30;
            if (30 >= minSdkVersion && "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.READ_EXTERNAL_STORAGE", sdkVersion);
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE", sdkVersion);
            }
            sdkVersion = 29;
            if (29 >= minSdkVersion && "android.permission.ACTIVITY_RECOGNITION".equals(permission2)) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.BODY_SENSORS", sdkVersion);
            }
            sdkVersion = 26;
            if (26 >= minSdkVersion && "android.permission.READ_PHONE_NUMBERS".equals(permission2)) {
                PermissionChecker.checkManifestPermission(manifestPermissions, "android.permission.READ_PHONE_NUMBERS", sdkVersion);
            }
            PermissionChecker.checkManifestPermission(manifestPermissions, permission2, Integer.MAX_VALUE);
        }
    }

    static void checkManifestPermission(HashMap<String, Integer> manifestPermissions, String checkPermission, int maxSdkVersion) {
        if (!manifestPermissions.containsKey(checkPermission)) {
            throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" />");
        }
        Integer manifestMaxSdkVersion = manifestPermissions.get(checkPermission);
        if (manifestMaxSdkVersion == null) {
            return;
        }
        if (manifestMaxSdkVersion < maxSdkVersion) {
            throw new IllegalArgumentException("The AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" /> does not meet the requirements, " + (maxSdkVersion != Integer.MAX_VALUE ? "the minimum requirement for maxSdkVersion is " + maxSdkVersion : "please delete the android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" attribute"));
        }
    }

    static void optimizeDeprecatedPermission(List<String> requestPermissions) {
        if (!PermissionUtils.isAndroid12() && requestPermissions.contains("android.permission.BLUETOOTH_SCAN") && !requestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
            requestPermissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (!PermissionUtils.isAndroid12() && requestPermissions.contains("android.permission.BLUETOOTH_SCAN")) {
            requestPermissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("If you have applied for MANAGE_EXTERNAL_STORAGE permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions");
            }
            if (!PermissionUtils.isAndroid11()) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
                requestPermissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (!PermissionUtils.isAndroid8() && requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") && !requestPermissions.contains("android.permission.READ_PHONE_STATE")) {
            requestPermissions.add("android.permission.READ_PHONE_STATE");
        }
        if (!PermissionUtils.isAndroid10() && requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") && !requestPermissions.contains("android.permission.BODY_SENSORS")) {
            requestPermissions.add("android.permission.BODY_SENSORS");
        }
    }
}

