/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.ArraySet;
import com.hjq.permissions.IPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@TargetApi(value=23)
public final class PermissionFragment
extends Fragment
implements Runnable {
    private static final String REQUEST_PERMISSIONS = "request_permissions";
    private static final String REQUEST_CODE = "request_code";
    private static final ArraySet<Integer> REQUEST_CODE_ARRAY = new ArraySet();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;
    private boolean mRequestFlag;
    private OnPermissionCallback mCallBack;
    private IPermissionInterceptor mInterceptor;
    private int mScreenOrientation;

    public static void beginRequest(Activity activity, ArrayList<String> permissions, IPermissionInterceptor interceptor, OnPermissionCallback callback) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Bundle bundle = new Bundle();
        while (REQUEST_CODE_ARRAY.contains((Object)(requestCode = PermissionUtils.getRandomRequestCode()))) {
        }
        REQUEST_CODE_ARRAY.add((Object)requestCode);
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(REQUEST_PERMISSIONS, permissions);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setCallBack(callback);
        fragment.setInterceptor(interceptor);
        fragment.attachActivity(activity);
    }

    public void attachActivity(Activity activity) {
        activity.getFragmentManager().beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachActivity(Activity activity) {
        activity.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void setCallBack(OnPermissionCallback callback) {
        this.mCallBack = callback;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void setInterceptor(IPermissionInterceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void onAttach(Context context) {
        super.onAttach(context);
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mScreenOrientation = activity.getRequestedOrientation();
        if (this.mScreenOrientation != -1) {
            return;
        }
        int activityOrientation = activity.getResources().getConfiguration().orientation;
        try {
            if (activityOrientation == 2) {
                activity.setRequestedOrientation(0);
            } else if (activityOrientation == 1) {
                activity.setRequestedOrientation(1);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void onDetach() {
        super.onDetach();
        Activity activity = this.getActivity();
        if (activity == null || this.mScreenOrientation != -1) {
            return;
        }
        activity.setRequestedOrientation(-1);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequestFlag) {
            this.detachActivity(this.getActivity());
            return;
        }
        if (this.mSpecialRequest) {
            return;
        }
        this.mSpecialRequest = true;
        this.requestSpecialPermission();
    }

    public void requestSpecialPermission() {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList permissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        boolean requestSpecialPermission = false;
        if (PermissionUtils.containsSpecialPermission(permissions)) {
            if (permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionUtils.isGrantedStoragePermission((Context)activity) && PermissionUtils.isAndroid11()) {
                this.startActivityForResult(PermissionSettingPage.getStoragePermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.isGrantedInstallPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getInstallPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.isGrantedWindowPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getWindowPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.NOTIFICATION_SERVICE") && !PermissionUtils.isGrantedNotifyPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getNotifyPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.WRITE_SETTINGS") && !PermissionUtils.isGrantedSettingPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getSettingPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
        }
        if (!requestSpecialPermission) {
            this.requestDangerousPermission();
        }
    }

    public void requestDangerousPermission() {
        final Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null) {
            return;
        }
        final int requestCode = arguments.getInt(REQUEST_CODE);
        final ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.size() == 0) {
            return;
        }
        ArrayList<String> locationPermission = null;
        if (PermissionUtils.isAndroid10() && allPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            locationPermission = new ArrayList<String>();
            if (allPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (allPermissions.contains("android.permission.ACCESS_FINE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_FINE_LOCATION");
            }
        }
        if (!PermissionUtils.isAndroid10() || locationPermission == null || locationPermission.isEmpty()) {
            this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
            return;
        }
        PermissionFragment.beginRequest(activity, locationPermission, null, new OnPermissionCallback(){

            @Override
            public void onGranted(List<String> permissions, boolean all) {
                if (!all || !PermissionFragment.this.isAdded()) {
                    return;
                }
                PermissionFragment.beginRequest(activity, PermissionUtils.asArrayList("android.permission.ACCESS_BACKGROUND_LOCATION"), null, new OnPermissionCallback(){

                    @Override
                    public void onGranted(List<String> permissions, boolean all) {
                        if (!all || !PermissionFragment.this.isAdded()) {
                            return;
                        }
                        int[] grantResults = new int[allPermissions.size()];
                        Arrays.fill(grantResults, 0);
                        PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
                    }

                    @Override
                    public void onDenied(List<String> permissions, boolean never) {
                        if (!PermissionFragment.this.isAdded()) {
                            return;
                        }
                        int[] grantResults = new int[allPermissions.size()];
                        for (int i = 0; i < allPermissions.size(); ++i) {
                            grantResults[i] = "android.permission.ACCESS_BACKGROUND_LOCATION".equals(allPermissions.get(i)) ? -1 : 0;
                        }
                        PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
                    }
                });
            }

            @Override
            public void onDenied(List<String> permissions, boolean never) {
                if (!PermissionFragment.this.isAdded()) {
                    return;
                }
                int[] grantResults = new int[allPermissions.size()];
                Arrays.fill(grantResults, -1);
                PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (activity == null || arguments == null || this.mCallBack == null || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        OnPermissionCallback callback = this.mCallBack;
        this.mCallBack = null;
        IPermissionInterceptor interceptor = this.mInterceptor;
        this.mInterceptor = null;
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (PermissionUtils.isSpecialPermission(permission2)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission2);
                continue;
            }
            if (!PermissionUtils.isAndroid12() && ("android.permission.BLUETOOTH_SCAN".equals(permission2) || "android.permission.BLUETOOTH_CONNECT".equals(permission2) || "android.permission.BLUETOOTH_ADVERTISE".equals(permission2))) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission2);
                continue;
            }
            if (!PermissionUtils.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2) || "android.permission.ACTIVITY_RECOGNITION".equals(permission2) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission2))) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission2);
                continue;
            }
            if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission2)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission2);
                continue;
            }
            if (PermissionUtils.isAndroid8() || !"android.permission.ANSWER_PHONE_CALLS".equals(permission2) && !"android.permission.READ_PHONE_NUMBERS".equals(permission2)) continue;
            grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission2);
        }
        REQUEST_CODE_ARRAY.remove((Object)requestCode);
        this.detachActivity(activity);
        List<String> grantedPermission = PermissionUtils.getGrantedPermissions(permissions, grantResults);
        if (grantedPermission.size() == permissions.length) {
            if (interceptor != null) {
                interceptor.grantedPermissions(activity, callback, grantedPermission, true);
            } else {
                callback.onGranted(grantedPermission, true);
            }
            return;
        }
        List<String> deniedPermission = PermissionUtils.getDeniedPermissions(permissions, grantResults);
        if (interceptor != null) {
            interceptor.deniedPermissions(activity, callback, deniedPermission, PermissionUtils.isPermissionPermanentDenied(activity, deniedPermission));
        } else {
            callback.onDenied(deniedPermission, PermissionUtils.isPermissionPermanentDenied(activity, deniedPermission));
        }
        if (!grantedPermission.isEmpty()) {
            if (interceptor != null) {
                interceptor.grantedPermissions(activity, callback, grantedPermission, false);
            } else {
                callback.onGranted(grantedPermission, false);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null || requestCode != arguments.getInt(REQUEST_CODE) || this.mDangerousRequest) {
            return;
        }
        this.mDangerousRequest = true;
        activity.getWindow().getDecorView().postDelayed((Runnable)this, 300L);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        this.requestDangerousPermission();
    }
}

