/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Build;
import com.hjq.permissions.ManifestRegisterException;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

final class PermissionChecker {
    PermissionChecker() {
    }

    static boolean checkActivityStatus(Activity activity, boolean debugMode) {
        if (activity == null) {
            if (debugMode) {
                throw new IllegalArgumentException("The instance of the context must be an activity object");
            }
            return false;
        }
        if (activity.isFinishing()) {
            if (debugMode) {
                throw new IllegalStateException("The activity has been finishing, please manually determine the status of the activity");
            }
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            if (debugMode) {
                throw new IllegalStateException("The activity has been destroyed, please manually determine the status of the activity");
            }
            return false;
        }
        return true;
    }

    static boolean checkPermissionArgument(List<String> requestPermissions, boolean debugMode) {
        if (requestPermissions == null || requestPermissions.isEmpty()) {
            if (debugMode) {
                throw new IllegalArgumentException("The requested permission cannot be empty");
            }
            return false;
        }
        if (debugMode) {
            ArrayList<String> allPermissions = new ArrayList<String>();
            Field[] fields = Permission.class.getDeclaredFields();
            if (fields.length == 0) {
                return true;
            }
            for (Field field : fields) {
                if (!String.class.equals(field.getType())) continue;
                try {
                    allPermissions.add((String)field.get(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            for (String permission2 : requestPermissions) {
                if (allPermissions.contains(permission2)) continue;
                throw new IllegalArgumentException("The " + permission2 + " is not a dangerous permission or special permission");
            }
        }
        return true;
    }

    static void checkStoragePermission(Context context, List<String> requestPermissions) {
        if (!(requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE"))) {
            return;
        }
        boolean scopedStorage = PermissionUtils.isScopedStorage(context);
        int cookie = PermissionUtils.findApkPathCookie(context);
        if (cookie == 0) {
            return;
        }
        try {
            XmlResourceParser parser = context.getAssets().openXmlResourceParser(cookie, "AndroidManifest.xml");
            while (parser.getEventType() != 1) {
                String nodeName;
                if (parser.getEventType() == 2 && "application".equals(nodeName = parser.getName())) {
                    String namespace = "http://schemas.android.com/apk/res/android";
                    int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
                    boolean requestLegacyExternalStorage = parser.getAttributeBooleanValue(namespace, "requestLegacyExternalStorage", false);
                    if (!(targetSdkVersion < 29 || requestLegacyExternalStorage || !requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && scopedStorage)) {
                        throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the manifest file");
                    }
                    if (targetSdkVersion < 30 || requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") || scopedStorage) break;
                    throw new IllegalArgumentException("Please adapt the scoped storage, or use the MANAGE_EXTERNAL_STORAGE permission");
                }
                parser.next();
            }
            parser.close();
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    static void checkLocationPermission(Context context, List<String> requestPermissions) {
        if (context.getApplicationInfo().targetSdkVersion >= 31 && requestPermissions.contains("android.permission.ACCESS_FINE_LOCATION") && !requestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
            throw new IllegalArgumentException("If your app targets Android 12 or higher and requests the ACCESS_FINE_LOCATION runtime permission, you must also request the ACCESS_COARSE_LOCATION permission. You must include both permissions in a single runtime request.");
        }
        if (!requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            return;
        }
        if (requestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION") && !requestPermissions.contains("android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalArgumentException("The application for background location permissions must include precise location permissions");
        }
        for (String permission2 : requestPermissions) {
            if ("android.permission.ACCESS_FINE_LOCATION".equals(permission2) || "android.permission.ACCESS_COARSE_LOCATION".equals(permission2) || "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission2)) continue;
            throw new IllegalArgumentException("Because it includes background location permissions, do not apply for permissions unrelated to location");
        }
    }

    static void checkTargetSdkVersion(Context context, List<String> requestPermissions) {
        int targetSdkMinVersion = requestPermissions.contains("android.permission.BLUETOOTH_SCAN") || requestPermissions.contains("android.permission.BLUETOOTH_CONNECT") || requestPermissions.contains("android.permission.BLUETOOTH_ADVERTISE") ? 31 : (requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") ? 30 : (requestPermissions.contains("android.permission.ACCEPT_HANDOVER") ? 28 : (requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION") || requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") || requestPermissions.contains("android.permission.ACCESS_MEDIA_LOCATION") ? 29 : (requestPermissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") || requestPermissions.contains("android.permission.ANSWER_PHONE_CALLS") || requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") ? 26 : 23))));
        if (context.getApplicationInfo().targetSdkVersion < targetSdkMinVersion) {
            throw new RuntimeException("The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more");
        }
    }

    static void optimizeDeprecatedPermission(List<String> requestPermissions) {
        if (!PermissionUtils.isAndroid12() && requestPermissions.contains("android.permission.BLUETOOTH_SCAN") && !requestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
            requestPermissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (!PermissionUtils.isAndroid12() && requestPermissions.contains("android.permission.BLUETOOTH_SCAN")) {
            requestPermissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("If you have applied for MANAGE_EXTERNAL_STORAGE permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions");
            }
            if (!PermissionUtils.isAndroid11()) {
                requestPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
                requestPermissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (!PermissionUtils.isAndroid8() && requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") && !requestPermissions.contains("android.permission.READ_PHONE_STATE")) {
            requestPermissions.add("android.permission.READ_PHONE_STATE");
        }
        if (!PermissionUtils.isAndroid10() && requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") && !requestPermissions.contains("android.permission.BODY_SENSORS")) {
            requestPermissions.add("android.permission.BODY_SENSORS");
        }
    }

    static void checkPermissionManifest(Context context, List<String> requestPermissions) {
        List<String> manifestPermissions = PermissionUtils.getManifestPermissions(context);
        if (manifestPermissions == null || manifestPermissions.isEmpty()) {
            throw new ManifestRegisterException();
        }
        int minSdkVersion = Build.VERSION.SDK_INT >= 24 ? context.getApplicationInfo().minSdkVersion : 23;
        for (String permission2 : requestPermissions) {
            if (minSdkVersion < 31) {
                if ("android.permission.BLUETOOTH_SCAN".equals(permission2)) {
                    if (!manifestPermissions.contains("android.permission.BLUETOOTH_ADMIN")) {
                        throw new ManifestRegisterException("android.permission.BLUETOOTH_ADMIN");
                    }
                    if (!manifestPermissions.contains("android.permission.ACCESS_COARSE_LOCATION")) {
                        throw new ManifestRegisterException("android.permission.ACCESS_COARSE_LOCATION");
                    }
                }
                if ("android.permission.BLUETOOTH_CONNECT".equals(permission2) && !manifestPermissions.contains("android.permission.BLUETOOTH")) {
                    throw new ManifestRegisterException("android.permission.BLUETOOTH");
                }
                if ("android.permission.BLUETOOTH_ADVERTISE".equals(permission2) && !manifestPermissions.contains("android.permission.BLUETOOTH_ADMIN")) {
                    throw new ManifestRegisterException("android.permission.BLUETOOTH_ADMIN");
                }
            }
            if (minSdkVersion < 30 && "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission2)) {
                if (!manifestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE")) {
                    throw new ManifestRegisterException("android.permission.READ_EXTERNAL_STORAGE");
                }
                if (!manifestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                    throw new ManifestRegisterException("android.permission.WRITE_EXTERNAL_STORAGE");
                }
            }
            if (minSdkVersion < 29 && "android.permission.ACTIVITY_RECOGNITION".equals(permission2) && !manifestPermissions.contains("android.permission.BODY_SENSORS")) {
                throw new ManifestRegisterException("android.permission.BODY_SENSORS");
            }
            if (minSdkVersion < 26 && "android.permission.READ_PHONE_NUMBERS".equals(permission2) && !manifestPermissions.contains("android.permission.READ_PHONE_STATE")) {
                throw new ManifestRegisterException("android.permission.READ_PHONE_STATE");
            }
            if ("android.permission.NOTIFICATION_SERVICE".equals(permission2) || manifestPermissions.contains(permission2)) continue;
            throw new ManifestRegisterException(permission2);
        }
    }
}

