/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.Permission;
import com.hjq.permissions.XXPermissions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

final class PermissionUtils {
    PermissionUtils() {
    }

    static boolean isAndroid11() {
        return Build.VERSION.SDK_INT >= 30;
    }

    static boolean isAndroid10() {
        return Build.VERSION.SDK_INT >= 29;
    }

    static boolean isAndroid9() {
        return Build.VERSION.SDK_INT >= 28;
    }

    static boolean isAndroid8() {
        return Build.VERSION.SDK_INT >= 26;
    }

    static boolean isAndroid7() {
        return Build.VERSION.SDK_INT >= 24;
    }

    static boolean isAndroid6() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static List<String> getManifestPermissions(Context context) {
        try {
            String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
            return PermissionUtils.asArrayList(requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static boolean isGrantedStoragePermission(Context context) {
        if (PermissionUtils.isAndroid11()) {
            return Environment.isExternalStorageManager();
        }
        return XXPermissions.isGranted(context, Permission.Group.STORAGE);
    }

    static boolean isGrantedInstallPermission(Context context) {
        if (PermissionUtils.isAndroid8()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean isGrantedWindowPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static boolean isGrantedNotifyPermission(Context context) {
        if (PermissionUtils.isAndroid7()) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (PermissionUtils.isAndroid6()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    static boolean isGrantedSettingPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission : permissions) {
            if (!PermissionUtils.isSpecialPermission(permission)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecialPermission(String permission) {
        return "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission) || "android.permission.REQUEST_INSTALL_PACKAGES".equals(permission) || "android.permission.SYSTEM_ALERT_WINDOW".equals(permission) || "android.permission.NOTIFICATION_SERVICE".equals(permission) || "android.permission.WRITE_SETTINGS".equals(permission);
    }

    static boolean isGrantedPermissions(Context context, List<String> permissions) {
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        for (String permission : permissions) {
            if (PermissionUtils.isGrantedPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        ArrayList<String> deniedPermission = new ArrayList<String>(permissions.size());
        if (!PermissionUtils.isAndroid6()) {
            return deniedPermission;
        }
        for (String permission : permissions) {
            if (PermissionUtils.isGrantedPermission(context, permission)) continue;
            deniedPermission.add(permission);
        }
        return deniedPermission;
    }

    static boolean isGrantedPermission(Context context, String permission) {
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission)) {
            return PermissionUtils.isGrantedStoragePermission(context);
        }
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission)) {
            return PermissionUtils.isGrantedInstallPermission(context);
        }
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission)) {
            return PermissionUtils.isGrantedWindowPermission(context);
        }
        if ("android.permission.NOTIFICATION_SERVICE".equals(permission)) {
            return PermissionUtils.isGrantedNotifyPermission(context);
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission)) {
            return PermissionUtils.isGrantedSettingPermission(context);
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission)) {
                return true;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission)) {
                return context.checkSelfPermission("android.permission.BODY_SENSORS") == 0;
            }
        }
        if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission)) {
            return true;
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission)) {
                return context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0;
            }
        }
        return context.checkSelfPermission(permission) == 0;
    }

    static int getPermissionStatus(Context context, String permission) {
        return PermissionUtils.isGrantedPermission(context, permission) ? 0 : -1;
    }

    static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.isPermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static boolean isPermissionPermanentDenied(Activity activity, String permission) {
        if (!PermissionUtils.isAndroid6()) {
            return false;
        }
        if (PermissionUtils.isSpecialPermission(permission)) {
            return false;
        }
        if (PermissionUtils.isAndroid10() && "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) && PermissionUtils.getPermissionStatus((Context)activity, "android.permission.ACCESS_BACKGROUND_LOCATION") == -1) {
            return PermissionUtils.isPermissionPermanentDenied(activity, "android.permission.ACCESS_COARSE_LOCATION") || PermissionUtils.isPermissionPermanentDenied(activity, "android.permission.ACCESS_FINE_LOCATION");
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission)) {
                return false;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission)) {
                return activity.checkSelfPermission("android.permission.BODY_SENSORS") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
        }
        if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission)) {
            return false;
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission)) {
                return activity.checkSelfPermission("android.permission.READ_PHONE_STATE") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
        }
        return activity.checkSelfPermission(permission) == -1 && !activity.shouldShowRequestPermissionRationale(permission);
    }

    static List<String> getDeniedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions[i]);
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions[i]);
        }
        return grantedPermissions;
    }

    static <T> ArrayList<T> asArrayList(T ... array) {
        if (array == null || array.length == 0) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    static int getRandomRequestCode() {
        return new Random().nextInt((int)Math.pow(2.0, 8.0));
    }

    static FragmentActivity findFragmentActivity(Context context) {
        do {
            if (context instanceof FragmentActivity) {
                return (FragmentActivity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }

    @SuppressLint(value={"PrivateApi"})
    static int findApkPathCookie(Context context) {
        AssetManager assets = context.getAssets();
        String path = context.getApplicationInfo().sourceDir;
        int cookie = 0;
        try {
            try {
                Method method = assets.getClass().getDeclaredMethod("addOverlayPath", String.class);
                cookie = (Integer)method.invoke((Object)assets, path);
            }
            catch (Exception e) {
                e.printStackTrace();
                Method method = assets.getClass().getDeclaredMethod("getApkPaths", new Class[0]);
                String[] apkPaths = (String[])method.invoke((Object)assets, new Object[0]);
                if (apkPaths == null) {
                    return cookie;
                }
                for (int i = 0; i < apkPaths.length; ++i) {
                    if (!apkPaths[i].equals(path)) continue;
                    cookie = i + 1;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookie;
    }
}

