/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.SparseBooleanArray;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.XXPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PermissionFragment
extends Fragment
implements Runnable {
    private static final String REQUEST_PERMISSIONS = "request_permissions";
    private static final String REQUEST_CODE = "request_code";
    private static final SparseBooleanArray REQUEST_CODE_ARRAY = new SparseBooleanArray();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;
    private OnPermissionCallback mCallBack;
    private int mScreenOrientation;

    public static void beginRequest(FragmentActivity activity, ArrayList<String> permissions, OnPermissionCallback callback) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Bundle bundle = new Bundle();
        while (REQUEST_CODE_ARRAY.get(requestCode = PermissionUtils.getRandomRequestCode())) {
        }
        REQUEST_CODE_ARRAY.put(requestCode, true);
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(REQUEST_PERMISSIONS, permissions);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setCallBack(callback);
        fragment.attachActivity(activity);
    }

    public void attachActivity(FragmentActivity activity) {
        activity.getSupportFragmentManager().beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachActivity(FragmentActivity activity) {
        activity.getSupportFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void setCallBack(OnPermissionCallback callback) {
        this.mCallBack = callback;
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void onAttach(Context context) {
        super.onAttach(context);
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mScreenOrientation = activity.getRequestedOrientation();
        if (this.mScreenOrientation != -1) {
            return;
        }
        int activityOrientation = activity.getResources().getConfiguration().orientation;
        try {
            if (activityOrientation == 2) {
                activity.setRequestedOrientation(0);
            } else if (activityOrientation == 1) {
                activity.setRequestedOrientation(1);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void onDetach() {
        super.onDetach();
        FragmentActivity activity = this.getActivity();
        if (activity == null || this.mScreenOrientation != -1) {
            return;
        }
        activity.setRequestedOrientation(-1);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    public void onResume() {
        super.onResume();
        if (this.mSpecialRequest) {
            return;
        }
        this.mSpecialRequest = true;
        this.requestSpecialPermission();
    }

    public void requestSpecialPermission() {
        Bundle arguments = this.getArguments();
        FragmentActivity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList permissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        boolean requestSpecialPermission = false;
        if (PermissionUtils.containsSpecialPermission(permissions)) {
            if (permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionUtils.isGrantedStoragePermission((Context)activity) && PermissionUtils.isAndroid11()) {
                this.startActivityForResult(PermissionSettingPage.getStoragePermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.isGrantedInstallPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getInstallPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.isGrantedWindowPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getWindowPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.NOTIFICATION_SERVICE") && !PermissionUtils.isGrantedNotifyPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getNotifyPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.WRITE_SETTINGS") && !PermissionUtils.isGrantedSettingPermission((Context)activity)) {
                this.startActivityForResult(PermissionSettingPage.getSettingPermissionIntent((Context)activity), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
        }
        if (!requestSpecialPermission) {
            this.requestDangerousPermission();
        }
    }

    public void requestDangerousPermission() {
        FragmentActivity activity = this.getActivity();
        final Bundle arguments = this.getArguments();
        if (activity == null || arguments == null) {
            return;
        }
        final ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.size() == 0) {
            return;
        }
        ArrayList<String> locationPermission = null;
        if (PermissionUtils.isAndroid10() && allPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            locationPermission = new ArrayList<String>();
            if (allPermissions.contains("android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (allPermissions.contains("android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.isGrantedPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_FINE_LOCATION");
            }
        }
        if (locationPermission == null || locationPermission.isEmpty()) {
            this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
            return;
        }
        PermissionFragment.beginRequest(activity, locationPermission, new OnPermissionCallback(){

            @Override
            public void onGranted(List<String> permissions, boolean all) {
                if (!all || !PermissionFragment.this.isAdded()) {
                    return;
                }
                PermissionFragment.this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), arguments.getInt(PermissionFragment.REQUEST_CODE));
            }

            @Override
            public void onDenied(List<String> permissions, boolean never) {
                if (!PermissionFragment.this.isAdded()) {
                    return;
                }
                if (permissions.size() == allPermissions.size() - 1) {
                    int[] grantResults = new int[allPermissions.size()];
                    Arrays.fill(grantResults, -1);
                    PermissionFragment.this.onRequestPermissionsResult(arguments.getInt(PermissionFragment.REQUEST_CODE), allPermissions.toArray(new String[0]), grantResults);
                    return;
                }
                PermissionFragment.this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), arguments.getInt(PermissionFragment.REQUEST_CODE));
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Bundle arguments = this.getArguments();
        FragmentActivity activity = this.getActivity();
        if (activity == null || arguments == null || this.mCallBack == null || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        OnPermissionCallback callBack = this.mCallBack;
        this.mCallBack = null;
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (PermissionUtils.isSpecialPermission(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission);
                continue;
            }
            if (PermissionUtils.isAndroid11() && "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission);
                continue;
            }
            if (!PermissionUtils.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACTIVITY_RECOGNITION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission))) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission);
                continue;
            }
            if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission);
                continue;
            }
            if (PermissionUtils.isAndroid8() || !"android.permission.ANSWER_PHONE_CALLS".equals(permission) && !"android.permission.READ_PHONE_NUMBERS".equals(permission)) continue;
            grantResults[i] = PermissionUtils.getPermissionStatus((Context)activity, permission);
        }
        REQUEST_CODE_ARRAY.delete(requestCode);
        this.detachActivity(activity);
        List<String> grantedPermission = PermissionUtils.getGrantedPermissions(permissions, grantResults);
        if (grantedPermission.size() == permissions.length) {
            XXPermissions.getInterceptor().grantedPermissions(activity, callBack, grantedPermission, true);
            return;
        }
        List<String> deniedPermission = PermissionUtils.getDeniedPermissions(permissions, grantResults);
        XXPermissions.getInterceptor().deniedPermissions(activity, callBack, deniedPermission, PermissionUtils.isPermissionPermanentDenied((Activity)activity, deniedPermission));
        if (!grantedPermission.isEmpty()) {
            XXPermissions.getInterceptor().grantedPermissions(activity, callBack, grantedPermission, false);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        FragmentActivity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null || requestCode != arguments.getInt(REQUEST_CODE) || this.mDangerousRequest) {
            return;
        }
        this.mDangerousRequest = true;
        activity.getWindow().getDecorView().postDelayed((Runnable)this, 200L);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        this.requestDangerousPermission();
    }
}

