/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.IPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionChecker;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static IPermissionInterceptor sPermissionInterceptor;
    private static Boolean sDebugMode;
    private static boolean sScopedStorage;
    private final Context mContext;
    private List<String> mPermissions;

    public static XXPermissions with(Context context) {
        return new XXPermissions(context);
    }

    public static XXPermissions with(Fragment fragment) {
        return XXPermissions.with((Context)fragment.getActivity());
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    private static boolean isDebugMode(Context context) {
        if (sDebugMode == null) {
            sDebugMode = (context.getApplicationInfo().flags & 2) != 0;
        }
        return sDebugMode;
    }

    public static void setScopedStorage(boolean scopedStorage) {
        sScopedStorage = scopedStorage;
    }

    private static boolean isScopedStorage() {
        return sScopedStorage;
    }

    public static void setPermissionInterceptor(IPermissionInterceptor interceptor) {
        sPermissionInterceptor = interceptor;
    }

    static IPermissionInterceptor getPermissionInterceptor() {
        if (sPermissionInterceptor == null) {
            sPermissionInterceptor = new IPermissionInterceptor(){};
        }
        return sPermissionInterceptor;
    }

    private XXPermissions(Context context) {
        this.mContext = context;
    }

    public XXPermissions permission(String permission) {
        if (this.mPermissions == null) {
            this.mPermissions = new ArrayList<String>(1);
        }
        this.mPermissions.add(permission);
        return this;
    }

    public XXPermissions permission(String[] permissions) {
        return this.permission(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions permission(List<String> permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = permissions;
        } else {
            this.mPermissions.addAll(permissions);
        }
        return this;
    }

    public void request(OnPermissionCallback callback) {
        if (this.mContext == null) {
            return;
        }
        boolean debugMode = XXPermissions.isDebugMode(this.mContext);
        FragmentActivity fragmentActivity = PermissionUtils.findFragmentActivity(this.mContext);
        if (!PermissionChecker.checkActivityStatus((Activity)fragmentActivity, debugMode)) {
            return;
        }
        if (!PermissionChecker.checkPermissionArgument(this.mPermissions, debugMode)) {
            return;
        }
        if (debugMode) {
            PermissionChecker.checkStoragePermission(this.mContext, this.mPermissions, XXPermissions.isScopedStorage());
            PermissionChecker.checkLocationPermission(this.mPermissions);
            PermissionChecker.checkTargetSdkVersion(this.mContext, this.mPermissions);
        }
        PermissionChecker.optimizeDeprecatedPermission(this.mPermissions);
        if (debugMode) {
            PermissionChecker.checkPermissionManifest(this.mContext, this.mPermissions);
        }
        if (PermissionUtils.isGrantedPermissions(this.mContext, this.mPermissions)) {
            if (callback != null) {
                callback.onGranted(this.mPermissions, true);
            }
            return;
        }
        XXPermissions.getPermissionInterceptor().requestPermissions(fragmentActivity, callback, this.mPermissions);
    }

    public static boolean isGrantedPermission(Context context, String permission) {
        return PermissionUtils.isGrantedPermission(context, permission);
    }

    public static boolean isGrantedPermission(Context context, String[] permissions) {
        return XXPermissions.isGrantedPermission(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGrantedPermission(Context context, List<String> permissions) {
        return PermissionUtils.isGrantedPermissions(context, permissions);
    }

    public static List<String> getDeniedPermissions(Context context, String[] permissions) {
        return XXPermissions.getDeniedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        return PermissionUtils.getDeniedPermissions(context, permissions);
    }

    public static boolean isPermissionPermanentDenied(Activity activity, String permission) {
        return PermissionUtils.isPermissionPermanentDenied(activity, permission);
    }

    public static boolean isPermissionPermanentDenied(Activity activity, String[] permissions) {
        return XXPermissions.isPermissionPermanentDenied(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        return PermissionUtils.isPermissionPermanentDenied(activity, permissions);
    }

    public static boolean isSpecialPermission(String permission) {
        return PermissionUtils.isSpecialPermission(permission);
    }

    public static void startApplicationDetails(Context context) {
        FragmentActivity activity = PermissionUtils.findFragmentActivity(context);
        if (activity != null) {
            XXPermissions.startApplicationDetails((Activity)activity);
            return;
        }
        Intent intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startApplicationDetails(Activity activity) {
        activity.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1025);
    }

    public static void startApplicationDetails(Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1025);
    }

    public static void startPermissionActivity(Context context, String permission) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permission));
    }

    public static void startPermissionActivity(Context context, String[] permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Context context, List<String> permissions) {
        FragmentActivity activity = PermissionUtils.findFragmentActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity((Activity)activity, permissions);
            return;
        }
        Intent intent = PermissionSettingPage.getSmartPermissionIntent(context, permissions);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startPermissionActivity(Activity activity, String permission) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission));
    }

    public static void startPermissionActivity(Activity activity, String[] permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Activity activity, List<String> permissions) {
        activity.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, permissions), 1025);
    }

    public static void startPermissionActivity(Fragment fragment, String permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, String[] permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, List<String> permissions) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, permissions), 1025);
    }
}

