/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.util.SparseArray;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class XXPermissions {
    private static final SparseArray<OnPermission> sContainer = new SparseArray();
    private static long sRequestTime;
    private Activity mActivity;
    private String[] mPermissions;

    private XXPermissions(Activity activity) {
        this.mActivity = activity;
    }

    public static XXPermissions with(Activity activity) {
        return new XXPermissions(activity);
    }

    public XXPermissions permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(Arrays.asList(group));
        }
        this.mPermissions = permissionList.toArray(new String[permissionList.size() - 1]);
        return this;
    }

    public XXPermissions permission(List<String> permissions) {
        this.mPermissions = permissions.toArray(new String[permissions.size() - 1]);
        return this;
    }

    public void request(OnPermission call) {
        int requestCode;
        if (this.mPermissions == null || this.mPermissions.length == 0) {
            this.mPermissions = PermissionUtils.getPermissions((Context)this.mActivity);
        }
        if (this.mPermissions == null || this.mPermissions.length == 0) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (this.mActivity == null) {
            throw new IllegalArgumentException("The activity is empty");
        }
        if (call == null) {
            throw new IllegalArgumentException("The permission request callback interface must be implemented");
        }
        while (sContainer.get(requestCode = new Random().nextInt(255)) != null) {
        }
        ArrayList<String> failPermissions = PermissionUtils.getFailPermissions((Context)this.mActivity, this.mPermissions);
        if (failPermissions == null) {
            call.hasPermission(Arrays.asList(this.mPermissions), true);
        } else {
            sContainer.put(requestCode, (Object)call);
            sRequestTime = System.currentTimeMillis();
            PermissionUtils.checkPermissions(this.mActivity, this.mPermissions);
            PermissionFragment.newInstant(failPermissions, requestCode).request(this.mActivity.getFragmentManager());
        }
    }

    public static boolean isHasPermission(Context context, String ... permissions) {
        return PermissionUtils.getFailPermissions(context, permissions) == null;
    }

    public static boolean isHasPermission(Context context, String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(Arrays.asList(group));
        }
        return PermissionUtils.getFailPermissions(context, permissionList.toArray(new String[permissionList.size() - 1])) == null;
    }

    public static void gotoPermissionSettings(Context context) {
        PermissionUtils.gotoPermissionSettings(context, false);
    }

    public static void gotoPermissionSettings(Context context, boolean newTask) {
        PermissionUtils.gotoPermissionSettings(context, newTask);
    }

    static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        OnPermission call = (OnPermission)sContainer.get(requestCode);
        if (call == null) {
            return;
        }
        List<String> succeedPermissions = PermissionUtils.getSucceedPermissions(permissions, grantResults);
        if (succeedPermissions.size() == permissions.length) {
            call.hasPermission(succeedPermissions, true);
        } else {
            List<String> failPermissions = PermissionUtils.getFailPermissions(permissions, grantResults);
            call.noPermission(failPermissions, System.currentTimeMillis() - sRequestTime < 200L);
            if (!succeedPermissions.isEmpty()) {
                call.hasPermission(succeedPermissions, false);
            }
        }
        sContainer.remove(requestCode);
    }
}

