/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class PermissionUtils {
    PermissionUtils() {
    }

    static void gotoPermissionSettings(Context context, boolean newTask) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        if (newTask) {
            intent.addFlags(0x10000000);
        }
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        context.startActivity(intent);
    }

    static String[] getPermissions(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            return pm.getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static ArrayList<String> getFailPermissions(Context context, String[] permissions) {
        if (!PermissionUtils.isOverMarshmallow()) {
            return null;
        }
        ArrayList<String> failPermissions = null;
        for (String permission : permissions) {
            if (context.checkSelfPermission(permission) != -1) continue;
            if (failPermissions == null) {
                failPermissions = new ArrayList<String>();
            }
            failPermissions.add(permission);
        }
        return failPermissions;
    }

    static List<String> getFailPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> failPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            failPermissions.add(permissions[i]);
        }
        return failPermissions;
    }

    static List<String> getSucceedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> succeedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            succeedPermissions.add(permissions[i]);
        }
        return succeedPermissions;
    }

    static void checkPermissions(Activity activity, String[] requestPermissions) {
        String[] permissions = PermissionUtils.getPermissions((Context)activity);
        if (permissions != null && permissions.length != 0) {
            List<String> manifest = Arrays.asList(permissions);
            for (String permission : requestPermissions) {
                if (manifest.contains(permission)) continue;
                throw new IllegalArgumentException(permission + ": Permissions are not registered in the manifest file");
            }
        } else {
            throw new IllegalArgumentException("Permissions are not registered in the manifest file");
        }
    }
}

