/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.util.SparseArray;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class XXPermissions {
    private static final SparseArray<OnPermission> mContainer = new SparseArray();
    private static long requestTime;
    private Activity mActivity;
    private String[] mPermissions;

    private XXPermissions(Activity activity) {
        this.mActivity = activity;
    }

    public static XXPermissions with(Activity activity) {
        return new XXPermissions(activity);
    }

    public XXPermissions permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(Arrays.asList(group));
        }
        this.mPermissions = permissionList.toArray(new String[permissionList.size() - 1]);
        return this;
    }

    public void request(OnPermission call) {
        int requestCode;
        if (this.mPermissions == null || this.mPermissions.length == 0) {
            this.mPermissions = PermissionUtils.getPermissions((Context)this.mActivity);
        }
        if (this.mPermissions == null || this.mPermissions.length == 0) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (this.mActivity == null) {
            throw new IllegalArgumentException("The activity is empty");
        }
        if (call == null) {
            throw new IllegalArgumentException("The permission request callback interface must be implemented");
        }
        while (mContainer.get(requestCode = new Random().nextInt(255)) != null) {
        }
        ArrayList<String> failPermissions = PermissionUtils.getFailPermissions((Context)this.mActivity, this.mPermissions);
        if (failPermissions.isEmpty()) {
            call.hasPermission(Arrays.asList(this.mPermissions));
        } else {
            mContainer.put(requestCode, (Object)call);
            requestTime = System.currentTimeMillis();
            PermissionUtils.checkPermissions(this.mActivity, this.mPermissions);
            PermissionFragment.newInstant(failPermissions, requestCode).request(this.mActivity.getFragmentManager());
        }
    }

    static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        OnPermission call = (OnPermission)mContainer.get(requestCode);
        if (call == null) {
            return;
        }
        List<String> succeedPermissions = PermissionUtils.getSucceedPermissions(permissions, grantResults);
        List<String> failPermissions = PermissionUtils.getFailPermissions(permissions, grantResults);
        if (succeedPermissions.size() == permissions.length) {
            call.hasPermission(succeedPermissions);
        } else {
            call.noPermission(failPermissions, System.currentTimeMillis() - requestTime < 200L);
            if (!succeedPermissions.isEmpty()) {
                call.hasPermission(succeedPermissions);
            }
        }
        mContainer.remove(requestCode);
    }
}

