/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.xtoast.draggable;

import android.content.res.Resources;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.hjq.xtoast.XToast;

public abstract class BaseDraggable
implements View.OnTouchListener {
    private XToast<?> mToast;
    private View mDecorView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowParams;

    public void start(XToast<?> toast) {
        this.mToast = toast;
        this.mDecorView = toast.getDecorView();
        this.mWindowManager = toast.getWindowManager();
        this.mWindowParams = toast.getWindowParams();
        this.mDecorView.setOnTouchListener((View.OnTouchListener)this);
    }

    protected XToast<?> getXToast() {
        return this.mToast;
    }

    protected WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    protected WindowManager.LayoutParams getWindowParams() {
        return this.mWindowParams;
    }

    protected View getRootView() {
        return this.mDecorView;
    }

    protected int getWindowWidth() {
        Rect rect = new Rect();
        this.getRootView().getWindowVisibleDisplayFrame(rect);
        return rect.right - rect.left;
    }

    protected int getWindowHeight() {
        Rect rect = new Rect();
        this.getRootView().getWindowVisibleDisplayFrame(rect);
        return rect.bottom - rect.top;
    }

    protected int getWindowInvisibleWidth() {
        Rect rect = new Rect();
        this.mDecorView.getWindowVisibleDisplayFrame(rect);
        return rect.left;
    }

    protected int getWindowInvisibleHeight() {
        Rect rect = new Rect();
        this.mDecorView.getWindowVisibleDisplayFrame(rect);
        return rect.top;
    }

    protected void updateLocation(float x, float y) {
        this.updateLocation((int)x, (int)y);
    }

    protected void updateLocation(int x, int y) {
        int screenGravity = 0x800033;
        if (this.mWindowParams.gravity == screenGravity && this.mWindowParams.x == x && this.mWindowParams.y == y) {
            return;
        }
        this.mWindowParams.x = x;
        this.mWindowParams.y = y;
        this.mWindowParams.gravity = screenGravity;
        try {
            this.mWindowManager.updateViewLayout(this.mDecorView, (ViewGroup.LayoutParams)this.mWindowParams);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    protected boolean isTouchMove(float downX, float upX, float downY, float upY) {
        float minTouchSlop = this.getScaledTouchSlop();
        return Math.abs(downX - upX) >= minTouchSlop || Math.abs(downY - upY) >= minTouchSlop;
    }

    protected float getScaledTouchSlop() {
        return TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }
}

