/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.xtoast.draggable;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import com.hjq.xtoast.draggable.BaseDraggable;

public class SpringDraggable
extends BaseDraggable {
    private float mViewDownX;
    private float mViewDownY;
    private final int mOrientation;
    private boolean mMoveTouch;

    public SpringDraggable() {
        this(0);
    }

    public SpringDraggable(int orientation) {
        this.mOrientation = orientation;
        switch (this.mOrientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("You cannot pass in directions other than horizontal or vertical");
            }
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mViewDownX = event.getX();
                this.mViewDownY = event.getY();
                this.mMoveTouch = false;
                break;
            }
            case 2: {
                float rawMoveX = event.getRawX() - (float)this.getWindowInvisibleWidth();
                float rawMoveY = event.getRawY() - (float)this.getWindowInvisibleHeight();
                this.updateLocation(rawMoveX - this.mViewDownX, rawMoveY - this.mViewDownY);
                if (this.mMoveTouch || !this.isTouchMove(this.mViewDownX, event.getX(), this.mViewDownY, event.getY())) break;
                this.mMoveTouch = true;
                break;
            }
            case 1: 
            case 3: {
                float rawMoveX = event.getRawX() - (float)this.getWindowInvisibleWidth();
                float rawMoveY = event.getRawY() - (float)this.getWindowInvisibleHeight();
                switch (this.mOrientation) {
                    case 0: {
                        int screenWidth = this.getWindowWidth();
                        float rawFinalX = rawMoveX < (float)screenWidth / 2.0f ? 0.0f : (float)screenWidth;
                        this.startHorizontalAnimation(rawMoveX - this.mViewDownX, rawFinalX - this.mViewDownX, rawMoveY - this.mViewDownY);
                        break;
                    }
                    case 1: {
                        int screenHeight = this.getWindowHeight();
                        float rawFinalY = rawMoveY < (float)screenHeight / 2.0f ? 0.0f : (float)screenHeight;
                        this.startVerticalAnimation(rawMoveX - this.mViewDownX, rawMoveY - this.mViewDownY, rawFinalY);
                        break;
                    }
                }
                return this.mMoveTouch;
            }
        }
        return false;
    }

    private void startHorizontalAnimation(float startX, float endX, final float y) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{startX, endX});
        animator.setDuration(500L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SpringDraggable.this.updateLocation(((Float)animation.getAnimatedValue()).floatValue(), y);
            }
        });
        animator.start();
    }

    private void startVerticalAnimation(final float x, float startY, float endY) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{startY, endY});
        animator.setDuration(500L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SpringDraggable.this.updateLocation(x, ((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        animator.start();
    }
}

