/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.Toast;
import com.hjq.toast.CustomToast;
import com.hjq.toast.IToastStrategy;
import com.hjq.toast.NormalToast;
import com.hjq.toast.SafeToast;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class ToastStrategy
extends Handler
implements IToastStrategy {
    private static final int DELAY_TIMEOUT = 200;
    private static final int TYPE_SHOW = 1;
    private static final int TYPE_CONTINUE = 2;
    private static final int TYPE_CANCEL = 3;
    private static final int MAX_TOAST_CAPACITY = 3;
    private volatile Queue<CharSequence> mQueue = this.getToastQueue();
    private volatile boolean mShow;
    private Toast mToast;

    public ToastStrategy() {
        super(Looper.getMainLooper());
    }

    @Override
    public Toast create(Application application) {
        NormalToast toast;
        if (Build.VERSION.SDK_INT >= 30) {
            toast = new CustomToast(application);
        } else if (Build.VERSION.SDK_INT == 25) {
            toast = new SafeToast(application);
        } else {
            boolean check = Build.VERSION.SDK_INT >= 29 || ToastStrategy.areNotificationsEnabled((Context)application) || "xiaomi".equals(Build.MANUFACTURER.toLowerCase());
            toast = check ? new NormalToast(application) : new CustomToast(application);
        }
        return toast;
    }

    @Override
    public void bind(Toast toast) {
        this.mToast = toast;
    }

    @Override
    public void show(CharSequence text) {
        if (!(!this.mQueue.isEmpty() && this.mQueue.contains(text) || this.mQueue.offer(text))) {
            this.mQueue.poll();
            this.mQueue.offer(text);
        }
        if (!this.mShow) {
            this.mShow = true;
            this.sendEmptyMessageDelayed(1, 200L);
        }
    }

    @Override
    public void cancel() {
        if (this.mShow) {
            this.mShow = false;
            this.sendEmptyMessage(3);
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                CharSequence text = this.mQueue.peek();
                if (text != null) {
                    this.mToast.setText(text);
                    this.mToast.show();
                    this.sendEmptyMessageDelayed(2, this.getToastDuration(text) + 200);
                    break;
                }
                this.mShow = false;
                break;
            }
            case 2: {
                this.mQueue.poll();
                if (!this.mQueue.isEmpty()) {
                    this.sendEmptyMessage(1);
                    break;
                }
                this.mShow = false;
                break;
            }
            case 3: {
                this.mShow = false;
                this.mQueue.clear();
                this.mToast.cancel();
                break;
            }
        }
    }

    public Queue<CharSequence> getToastQueue() {
        return new ArrayBlockingQueue<CharSequence>(3);
    }

    public int getToastDuration(CharSequence text) {
        return text.length() > 20 ? 3500 : 2000;
    }

    private static boolean areNotificationsEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignored) {
                return true;
            }
        }
        return true;
    }
}

