/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.hjq.toast.BaseToast;
import com.hjq.toast.IToastInterceptor;
import com.hjq.toast.IToastStrategy;
import com.hjq.toast.IToastStyle;
import com.hjq.toast.SafeToast;
import com.hjq.toast.SupportToast;
import com.hjq.toast.ToastInterceptor;
import com.hjq.toast.ToastStrategy;
import com.hjq.toast.style.ToastBlackStyle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ToastUtils {
    private static IToastInterceptor sInterceptor;
    private static IToastStrategy sStrategy;
    private static Toast sToast;

    private ToastUtils() {
    }

    public static void init(Application application) {
        ToastUtils.init(application, new ToastBlackStyle((Context)application));
    }

    public static void init(Application application, IToastStyle style2) {
        ToastUtils.checkNullPointer(application);
        if (sInterceptor == null) {
            ToastUtils.setToastInterceptor(new ToastInterceptor());
        }
        if (sStrategy == null) {
            ToastUtils.setToastStrategy(new ToastStrategy());
        }
        if (ToastUtils.areNotificationsEnabled((Context)application)) {
            if (Build.VERSION.SDK_INT == 25) {
                ToastUtils.setToast(new SafeToast(application));
            } else {
                ToastUtils.setToast(new BaseToast(application));
            }
        } else {
            ToastUtils.setToast(new SupportToast(application));
        }
        ToastUtils.setView((View)ToastUtils.createTextView((Context)application, style2));
        ToastUtils.setGravity(style2.getGravity(), style2.getXOffset(), style2.getYOffset());
    }

    public static void show(Object object) {
        ToastUtils.show(object != null ? object.toString() : "null");
    }

    public static void show(int id2) {
        ToastUtils.checkToastState();
        try {
            ToastUtils.show(ToastUtils.getContext().getResources().getText(id2));
        }
        catch (Resources.NotFoundException ignored) {
            ToastUtils.show(String.valueOf(id2));
        }
    }

    public static void show(int id2, Object ... args) {
        ToastUtils.show(ToastUtils.getContext().getResources().getString(id2), args);
    }

    public static void show(String format, Object ... args) {
        ToastUtils.show(String.format(format, args));
    }

    public static synchronized void show(CharSequence text) {
        ToastUtils.checkToastState();
        if (sInterceptor.intercept(sToast, text)) {
            return;
        }
        sStrategy.show(text);
    }

    public static synchronized void cancel() {
        ToastUtils.checkToastState();
        sStrategy.cancel();
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.checkToastState();
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)sToast.getView().getResources().getConfiguration().getLayoutDirection());
        }
        sToast.setGravity(gravity, xOffset, yOffset);
    }

    public static void setView(int id2) {
        ToastUtils.checkToastState();
        ToastUtils.setView(View.inflate((Context)ToastUtils.getContext(), (int)id2, null));
    }

    public static void setView(View view) {
        ToastUtils.checkToastState();
        ToastUtils.checkNullPointer(view);
        Context context = view.getContext();
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("The view must be initialized using the context of the application");
        }
        if (sToast != null) {
            sToast.cancel();
            sToast.setView(view);
        }
    }

    public static <V extends View> V getView() {
        ToastUtils.checkToastState();
        return (V)sToast.getView();
    }

    public static void initStyle(IToastStyle style2) {
        ToastUtils.checkNullPointer(style2);
        if (sToast != null) {
            sToast.cancel();
            sToast.setView((View)ToastUtils.createTextView(ToastUtils.getContext(), style2));
            sToast.setGravity(style2.getGravity(), style2.getXOffset(), style2.getYOffset());
        }
    }

    public static void setToast(Toast toast) {
        ToastUtils.checkNullPointer(toast);
        if (sToast != null && toast.getView() == null) {
            toast.setView(sToast.getView());
            toast.setGravity(sToast.getGravity(), sToast.getXOffset(), sToast.getYOffset());
            toast.setMargin(sToast.getHorizontalMargin(), sToast.getVerticalMargin());
        }
        sToast = toast;
        if (sStrategy != null) {
            sStrategy.bind(sToast);
        }
    }

    public static void setToastStrategy(IToastStrategy handler) {
        ToastUtils.checkNullPointer(handler);
        sStrategy = handler;
        if (sToast != null) {
            sStrategy.bind(sToast);
        }
    }

    public static void setToastInterceptor(IToastInterceptor interceptor) {
        ToastUtils.checkNullPointer(interceptor);
        sInterceptor = interceptor;
    }

    public static Toast getToast() {
        return sToast;
    }

    private static void checkToastState() {
        if (sToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
    }

    private static void checkNullPointer(Object object) {
        if (object == null) {
            throw new NullPointerException("are you ok?");
        }
    }

    private static TextView createTextView(Context context, IToastStyle style2) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(style2.getBackgroundColor());
        drawable.setCornerRadius((float)style2.getCornerRadius());
        TextView textView = new TextView(context);
        textView.setId(16908299);
        textView.setTextColor(style2.getTextColor());
        textView.setTextSize(0, style2.getTextSize());
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setPaddingRelative(style2.getPaddingStart(), style2.getPaddingTop(), style2.getPaddingEnd(), style2.getPaddingBottom());
        } else {
            textView.setPadding(style2.getPaddingStart(), style2.getPaddingTop(), style2.getPaddingEnd(), style2.getPaddingBottom());
        }
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground((Drawable)drawable);
        } else {
            textView.setBackgroundDrawable((Drawable)drawable);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setZ((float)style2.getZ());
        }
        if (style2.getMaxLines() > 0) {
            textView.setMaxLines(style2.getMaxLines());
        }
        return textView;
    }

    private static Context getContext() {
        ToastUtils.checkToastState();
        return sToast.getView().getContext();
    }

    private static boolean areNotificationsEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            return manager != null && manager.areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            ApplicationInfo appInfo = context.getApplicationInfo();
            String packageName = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            try {
                Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field opPostNotificationValue = appOpsClass.getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)opPostNotificationValue.get(Integer.class);
                return (Integer)checkOpNoThrowMethod.invoke((Object)appOps, value, uid, packageName) == 0;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignored) {
                return true;
            }
        }
        return true;
    }
}

