/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import com.hjq.toast.WindowHelper;

final class ToastHelper
extends Handler {
    private static final String TOAST = "Toast";
    private final Toast mToast;
    private final WindowHelper mWindowHelper;
    private final String mPackageName;
    private boolean isShow;

    ToastHelper(Toast toast, Application application) {
        super(Looper.getMainLooper());
        this.mToast = toast;
        this.mPackageName = application.getPackageName();
        this.mWindowHelper = WindowHelper.register(this, application);
    }

    public void handleMessage(Message msg) {
        this.cancel();
    }

    void show() {
        if (!this.isShow) {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.format = -3;
            params.windowAnimations = 16973828;
            params.setTitle((CharSequence)TOAST);
            params.flags = 152;
            params.packageName = this.mPackageName;
            params.gravity = this.mToast.getGravity();
            params.x = this.mToast.getXOffset();
            params.y = this.mToast.getYOffset();
            try {
                this.mWindowHelper.getWindowManager().addView(this.mToast.getView(), (ViewGroup.LayoutParams)params);
                this.isShow = true;
                this.sendEmptyMessageDelayed(0, this.mToast.getDuration() == 1 ? 3500L : 2000L);
            }
            catch (WindowManager.BadTokenException | IllegalStateException | NullPointerException throwable) {
                // empty catch block
            }
        }
    }

    void cancel() {
        this.removeMessages(0);
        if (this.isShow) {
            try {
                this.mWindowHelper.getWindowManager().removeView(this.mToast.getView());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            this.isShow = false;
        }
    }
}

