/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.content.res.Resources;
import com.hjq.toast.ToastLogInterceptor;
import com.hjq.toast.ToastParams;
import com.hjq.toast.ToastStrategy;
import com.hjq.toast.config.IToastInterceptor;
import com.hjq.toast.config.IToastStrategy;
import com.hjq.toast.config.IToastStyle;
import com.hjq.toast.style.BlackToastStyle;
import com.hjq.toast.style.CustomViewToastStyle;
import com.hjq.toast.style.LocationToastStyle;

public final class ToastUtils {
    private static Application sApplication;
    private static IToastStrategy sToastStrategy;
    private static IToastStyle<?> sToastStyle;
    private static IToastInterceptor sToastInterceptor;
    private static Boolean sDebugMode;

    private ToastUtils() {
    }

    public static void init(Application application) {
        ToastUtils.init(application, sToastStyle);
    }

    public static void init(Application application, IToastStrategy strategy) {
        ToastUtils.init(application, strategy, null);
    }

    public static void init(Application application, IToastStyle<?> style2) {
        ToastUtils.init(application, null, style2);
    }

    public static void init(Application application, IToastStrategy strategy, IToastStyle<?> style2) {
        sApplication = application;
        if (strategy == null) {
            strategy = new ToastStrategy();
        }
        ToastUtils.setStrategy(strategy);
        if (style2 == null) {
            style2 = new BlackToastStyle();
        }
        ToastUtils.setStyle(style2);
    }

    public static boolean isInit() {
        return sApplication != null && sToastStrategy != null && sToastStyle != null;
    }

    public static void delayedShow(int id2, long delayMillis) {
        ToastUtils.delayedShow(ToastUtils.stringIdToCharSequence(id2), delayMillis);
    }

    public static void delayedShow(Object object, long delayMillis) {
        ToastUtils.delayedShow(ToastUtils.objectToCharSequence(object), delayMillis);
    }

    public static void delayedShow(CharSequence text, long delayMillis) {
        ToastParams params = new ToastParams();
        params.text = text;
        params.delayMillis = delayMillis;
        ToastUtils.show(params);
    }

    public static void debugShow(int id2) {
        ToastUtils.debugShow(ToastUtils.stringIdToCharSequence(id2));
    }

    public static void debugShow(Object object) {
        ToastUtils.debugShow(ToastUtils.objectToCharSequence(object));
    }

    public static void debugShow(CharSequence text) {
        if (!ToastUtils.isDebugMode()) {
            return;
        }
        ToastParams params = new ToastParams();
        params.text = text;
        ToastUtils.show(params);
    }

    public static void showShort(int id2) {
        ToastUtils.showShort(ToastUtils.stringIdToCharSequence(id2));
    }

    public static void showShort(Object object) {
        ToastUtils.showShort(ToastUtils.objectToCharSequence(object));
    }

    public static void showShort(CharSequence text) {
        ToastParams params = new ToastParams();
        params.text = text;
        params.duration = 0;
        ToastUtils.show(params);
    }

    public static void showLong(int id2) {
        ToastUtils.showLong(ToastUtils.stringIdToCharSequence(id2));
    }

    public static void showLong(Object object) {
        ToastUtils.showLong(ToastUtils.objectToCharSequence(object));
    }

    public static void showLong(CharSequence text) {
        ToastParams params = new ToastParams();
        params.text = text;
        params.duration = 1;
        ToastUtils.show(params);
    }

    public static void show(int id2) {
        ToastUtils.show(ToastUtils.stringIdToCharSequence(id2));
    }

    public static void show(Object object) {
        ToastUtils.show(ToastUtils.objectToCharSequence(object));
    }

    public static void show(CharSequence text) {
        ToastParams params = new ToastParams();
        params.text = text;
        ToastUtils.show(params);
    }

    public static void show(ToastParams params) {
        if (params.text == null || params.text.length() == 0) {
            return;
        }
        if (params.strategy == null) {
            params.strategy = sToastStrategy;
        }
        if (params.interceptor == null) {
            if (sToastInterceptor == null) {
                sToastInterceptor = new ToastLogInterceptor();
            }
            params.interceptor = sToastInterceptor;
        }
        if (params.style == null) {
            params.style = sToastStyle;
        }
        if (params.interceptor.intercept(params)) {
            return;
        }
        if (params.duration == -1) {
            params.duration = params.text.length() > 20 ? 1 : 0;
        }
        params.strategy.showToast(params);
    }

    public static void cancel() {
        sToastStrategy.cancelToast();
    }

    public static void setGravity(int gravity) {
        ToastUtils.setGravity(gravity, 0, 0);
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.setGravity(gravity, xOffset, yOffset, 0.0f, 0.0f);
    }

    public static void setGravity(int gravity, int xOffset, int yOffset, float horizontalMargin, float verticalMargin) {
        sToastStyle = new LocationToastStyle(sToastStyle, gravity, xOffset, yOffset, horizontalMargin, verticalMargin);
    }

    public static void setView(int id2) {
        if (id2 <= 0) {
            return;
        }
        ToastUtils.setStyle(new CustomViewToastStyle(id2, sToastStyle.getGravity(), sToastStyle.getXOffset(), sToastStyle.getYOffset(), sToastStyle.getHorizontalMargin(), sToastStyle.getVerticalMargin()));
    }

    public static void setStyle(IToastStyle<?> style2) {
        sToastStyle = style2;
    }

    public static IToastStyle<?> getStyle() {
        return sToastStyle;
    }

    public static void setStrategy(IToastStrategy strategy) {
        sToastStrategy = strategy;
        sToastStrategy.registerStrategy(sApplication);
    }

    public static IToastStrategy getStrategy() {
        return sToastStrategy;
    }

    public static void setInterceptor(IToastInterceptor interceptor) {
        sToastInterceptor = interceptor;
    }

    public static IToastInterceptor getInterceptor() {
        return sToastInterceptor;
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    static boolean isDebugMode() {
        if (sDebugMode == null) {
            sDebugMode = (ToastUtils.sApplication.getApplicationInfo().flags & 2) != 0;
        }
        return sDebugMode;
    }

    private static CharSequence stringIdToCharSequence(int id2) {
        try {
            return sApplication.getResources().getText(id2);
        }
        catch (Resources.NotFoundException ignored) {
            return String.valueOf(id2);
        }
    }

    private static CharSequence objectToCharSequence(Object object) {
        return object != null ? object.toString() : "null";
    }
}

