/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.util.Log;
import com.hjq.toast.ToastParams;
import com.hjq.toast.ToastUtils;
import com.hjq.toast.config.IToastInterceptor;
import java.lang.reflect.Modifier;

public class ToastLogInterceptor
implements IToastInterceptor {
    @Override
    public boolean intercept(ToastParams params) {
        this.printToast(params.text);
        return false;
    }

    protected void printToast(CharSequence text) {
        StackTraceElement[] stackTraces;
        if (!this.isLogEnable()) {
            return;
        }
        for (StackTraceElement stackTrace : stackTraces = new Throwable().getStackTrace()) {
            int lineNumber = stackTrace.getLineNumber();
            if (lineNumber <= 0) continue;
            String className = stackTrace.getClassName();
            try {
                Class<?> clazz = Class.forName(className);
                if (this.filterClass(clazz)) continue;
                this.printLog("(" + stackTrace.getFileName() + ":" + lineNumber + ") " + text.toString());
                break;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isLogEnable() {
        return ToastUtils.isDebugMode();
    }

    protected void printLog(String msg) {
        Log.i((String)"ToastUtils", (String)msg);
    }

    protected boolean filterClass(Class<?> clazz) {
        if (ToastLogInterceptor.class.equals(clazz)) {
            return true;
        }
        if (ToastUtils.class.equals(clazz)) {
            return true;
        }
        if (clazz.isInterface()) {
            return true;
        }
        return Modifier.isAbstract(clazz.getModifiers());
    }
}

