/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar.style;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.hjq.bar.ITitleBarStyle;

public abstract class BaseTitleBarStyle
implements ITitleBarStyle {
    private Context mContext;

    public BaseTitleBarStyle(Context context) {
        this.mContext = context;
    }

    @Override
    public int getTitleGravity() {
        return 17;
    }

    @Override
    public int getDrawablePadding() {
        return this.dp2px(2.0f);
    }

    @Override
    public int getChildPadding() {
        return this.dp2px(12.0f);
    }

    @Override
    public int getLineSize() {
        return 1;
    }

    @Override
    public int getTitleBarHeight() {
        if (Build.VERSION.SDK_INT >= 11) {
            TypedArray ta = this.mContext.obtainStyledAttributes(new int[]{16843499});
            int actionBarSize = (int)ta.getDimension(0, 0.0f);
            ta.recycle();
            return actionBarSize;
        }
        return this.dp2px(56.0f);
    }

    @Override
    public float getLeftSize() {
        return this.sp2px(14.0f);
    }

    @Override
    public float getTitleSize() {
        return this.sp2px(16.0f);
    }

    @Override
    public float getRightSize() {
        return this.sp2px(14.0f);
    }

    public Context getContext() {
        return this.mContext;
    }

    protected Drawable getDrawable(int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.getContext().getResources().getDrawable(id, this.getContext().getTheme());
        }
        return this.getContext().getResources().getDrawable(id);
    }

    protected int dp2px(float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    protected int sp2px(float spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }
}

