/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

final class ViewCore {
    ViewCore() {
    }

    static LinearLayout newMainLayout(Context context) {
        LinearLayout mainLayout = new LinearLayout(context);
        mainLayout.setOrientation(0);
        mainLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return mainLayout;
    }

    static View newLineView(Context context) {
        View lineView = new View(context);
        lineView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, 1, 80));
        return lineView;
    }

    static TextView newLeftView(Context context) {
        TextView leftView = new TextView(context);
        leftView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        leftView.setGravity(16);
        leftView.setFocusable(true);
        leftView.setClickable(true);
        leftView.setSingleLine();
        leftView.setEllipsize(TextUtils.TruncateAt.END);
        return leftView;
    }

    static TextView newTitleView(Context context) {
        TextView titleView = new TextView(context);
        titleView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        titleView.setGravity(17);
        titleView.setFocusable(true);
        titleView.setSingleLine();
        if (Build.VERSION.SDK_INT >= 2) {
            titleView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            titleView.setMarqueeRepeatLimit(-1);
            titleView.setSelected(true);
        } else {
            titleView.setEllipsize(TextUtils.TruncateAt.END);
        }
        return titleView;
    }

    static TextView newRightView(Context context) {
        TextView rightView = new TextView(context);
        rightView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        rightView.setGravity(16);
        rightView.setFocusable(true);
        rightView.setClickable(true);
        rightView.setSingleLine();
        rightView.setEllipsize(TextUtils.TruncateAt.END);
        return rightView;
    }

    static boolean hasTextViewContent(TextView view) {
        Drawable[] drawables;
        if (!"".equals(view.getText().toString())) {
            return true;
        }
        for (Drawable drawable2 : drawables = view.getCompoundDrawables()) {
            if (drawable2 == null) continue;
            return true;
        }
        return false;
    }

    static Drawable getDrawable(Context context, int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(id);
        }
        return context.getResources().getDrawable(id);
    }

    static void setBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(background);
        } else {
            view.setBackgroundDrawable(background);
        }
    }
}

